/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.selector;

import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.impl.Lists;
import com.codeborne.selenide.selector.ByShadowCss;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByShadow
extends By
implements Serializable {
    private static final String GET_SHADOW_ROOT_SCRIPT = "return arguments[0].shadowRoot";
    private final By target;
    private final List<By> shadowHosts;

    public ByShadow(By target, By shadowHost, By ... innerShadowHosts) {
        if (target == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null");
        }
        this.target = target;
        this.shadowHosts = Lists.list(shadowHost, innerShadowHosts);
    }

    public WebElement findElement(SearchContext context) {
        List<WebElement> found = this.findElements(context);
        if (found.isEmpty()) {
            throw new NoSuchElementException("Cannot locate an element " + String.valueOf(this.target) + " in shadow roots " + this.describeShadowRoots());
        }
        return found.get(0);
    }

    public List<WebElement> findElements(SearchContext context) {
        if (this.shadowHosts.isEmpty()) {
            return context.findElements(this.target);
        }
        List<Object> shadowRoots = ByShadow.findShadowRoots(context, this.shadowHosts.get(0));
        int shadowHostCount = this.shadowHosts.size();
        for (int i = 1; i < shadowHostCount; ++i) {
            By shadowHost = this.shadowHosts.get(i);
            shadowRoots = shadowRoots.stream().map(shadowRoot -> ByShadow.findShadowRoots(shadowRoot, shadowHost)).flatMap(Collection::stream).toList();
        }
        return shadowRoots.stream().map(shadowRoot -> shadowRoot.findElements(this.target)).flatMap(Collection::stream).toList();
    }

    private static List<SearchContext> findShadowRoots(SearchContext searchContext, By shadowHost) {
        return searchContext.findElements(shadowHost).stream().map(ByShadow::getShadowRoot).filter(Optional::isPresent).map(Optional::get).toList();
    }

    public static Optional<SearchContext> getShadowRoot(WebElement element) {
        JavascriptExecutor executor = JavaScript.jsExecutor((SearchContext)element);
        SearchContext shadowRoot = (SearchContext)executor.executeScript(GET_SHADOW_ROOT_SCRIPT, new Object[]{element});
        return Optional.ofNullable(shadowRoot);
    }

    public String toString() {
        return String.format("By.shadow: { %s -> %s }", this.describeShadowRoots(), this.target);
    }

    private String describeShadowRoots() {
        return this.shadowHosts.stream().map(By::toString).collect(Collectors.joining(" -> "));
    }

    public static By cssSelector(String target, String shadowHost, String ... innerShadowHosts) {
        return ByShadowCss.cssSelector(target, shadowHost, innerShadowHosts);
    }
}

