/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import com.browserup.bup.filters.RequestFilter;
import com.browserup.bup.util.HttpMessageContents;
import com.browserup.bup.util.HttpMessageInfo;
import com.codeborne.selenide.AuthenticationType;
import com.codeborne.selenide.Credentials;
import com.codeborne.selenide.drivercommands.BasicAuthUtils;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class AuthenticationFilter
implements RequestFilter {
    private @Nullable AuthenticationType authenticationType;
    private @Nullable Credentials credentials;

    public @Nullable HttpResponse filterRequest(HttpRequest request, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        this.validate();
        if (this.authenticationType != null && BasicAuthUtils.uriMatchesDomain(messageInfo.getUrl(), Objects.requireNonNull(this.credentials).domain())) {
            String authorization = String.format("%s %s", this.authenticationType.getValue(), this.credentials.encode());
            HttpHeaders headers = request.headers();
            headers.add("Authorization", (Object)authorization);
            headers.add("Proxy-Authorization", (Object)authorization);
        }
        return null;
    }

    public void setAuthentication(@Nullable AuthenticationType authenticationType, @Nullable Credentials credentials) {
        this.authenticationType = authenticationType;
        this.credentials = credentials;
        this.validate();
    }

    public void removeAuthentication() {
        this.setAuthentication(null, null);
    }

    private void validate() {
        if (this.authenticationType != null && this.credentials == null) {
            throw new IllegalArgumentException("Authentication type is provided, but credentials not provided");
        }
        if (this.authenticationType == null && this.credentials != null) {
            throw new IllegalArgumentException("Credentials are provided, but authentication type not provided");
        }
    }
}

