/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.As;
import com.codeborne.selenide.BaseElementsCollection;
import com.codeborne.selenide.Container;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.PageObjectException;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.ElementsContainerCollection;
import com.codeborne.selenide.impl.LazyCollectionSnapshot;
import com.codeborne.selenide.impl.LazyWebElementSnapshot;
import com.codeborne.selenide.impl.NoOpsList;
import com.codeborne.selenide.impl.PageObjectFactory;
import com.codeborne.selenide.impl.SelenideAnnotations;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class SelenidePageFactory
implements PageObjectFactory {
    private static final Type[] NO_TYPE = new Type[0];

    @Override
    public <PageObjectClass> PageObjectClass page(Driver driver, Class<PageObjectClass> pageObjectClass) {
        try {
            Constructor<PageObjectClass> constructor = pageObjectClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return this.page(driver, constructor.newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new PageObjectException("Failed to create new instance of " + String.valueOf(pageObjectClass), e);
        }
    }

    @Override
    public <PageObjectClass, T extends PageObjectClass> PageObjectClass page(Driver driver, T pageObject) {
        Type[] types = pageObject.getClass().getGenericInterfaces();
        this.initElements(driver, null, pageObject, types);
        return pageObject;
    }

    public void initElements(Driver driver, @Nullable WebElementSource searchContext, Object page, Type[] genericTypes) {
        for (Class<?> proxyIn = page.getClass(); proxyIn != Object.class; proxyIn = proxyIn.getSuperclass()) {
            this.initFields(driver, searchContext, page, proxyIn, genericTypes);
        }
    }

    protected void initFields(Driver driver, @Nullable WebElementSource searchContext, Object page, Class<?> proxyIn, Type[] genericTypes) {
        Field[] fields;
        for (Field field : fields = proxyIn.getDeclaredFields()) {
            this.initField(driver, searchContext, page, genericTypes, field);
        }
    }

    protected void initField(Driver driver, @Nullable WebElementSource searchContext, Object page, Type[] genericTypes, Field field) {
        Object value = this.createFieldValue(driver, searchContext, page, genericTypes, field);
        if (value != null) {
            this.setFieldValue(page, field, value);
        }
    }

    protected @Nullable Object createFieldValue(Driver driver, @Nullable WebElementSource searchContext, Object page, Type[] genericTypes, Field field) {
        Object fieldValue = this.getFieldValue(page, field);
        if (fieldValue == null) {
            By selector = this.findSelector(driver, field);
            return this.decorate(page.getClass().getClassLoader(), driver, searchContext, field, selector, genericTypes);
        }
        As as = SelenidePageFactory.aliasOf(field);
        if (as != null && fieldValue instanceof SelenideElement) {
            SelenideElement element = (SelenideElement)fieldValue;
            return element.as(as.value());
        }
        if (as != null && fieldValue instanceof BaseElementsCollection) {
            BaseElementsCollection collection = (BaseElementsCollection)fieldValue;
            return collection.as(as.value());
        }
        return null;
    }

    protected By findSelector(Driver driver, Field field) {
        return new SelenideAnnotations(field).buildBy();
    }

    protected boolean shouldCache(Field field) {
        return new SelenideAnnotations(field).isLookupCached();
    }

    protected void setFieldValue(Object page, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(page, value);
        }
        catch (IllegalAccessException e) {
            throw new PageObjectException("Failed to assign field " + String.valueOf(field) + " to value " + String.valueOf(value), e);
        }
    }

    protected @Nullable Object getFieldValue(Object page, Field field) {
        try {
            field.setAccessible(true);
            return field.get(page);
        }
        catch (IllegalAccessException e) {
            throw new PageObjectException("Failed to access field " + String.valueOf(field) + " in " + String.valueOf(page), e);
        }
    }

    @Override
    public Container createElementsContainer(Driver driver, @Nullable WebElementSource searchContext, Field field, By selector) {
        try {
            WebElementSource self = new ElementFinder(driver, searchContext, selector, 0, SelenidePageFactory.isShadowRoot(field, field.getType()), this.alias(field));
            if (this.shouldCache(field)) {
                self = new LazyWebElementSnapshot(self);
            }
            return this.initElementsContainer(driver, field, self);
        }
        catch (ReflectiveOperationException e) {
            throw new PageObjectException("Failed to create elements container for field " + field.getName(), e);
        }
    }

    static boolean isShadowRoot(Field field, Class<?> type) {
        return field.isAnnotationPresent(Container.ShadowRoot.class) || type.isAnnotationPresent(Container.ShadowRoot.class);
    }

    Container initElementsContainer(Driver driver, Field field, WebElementSource self) throws ReflectiveOperationException {
        Type[] typeArray;
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            typeArray = parameterizedType.getActualTypeArguments();
        } else {
            typeArray = NO_TYPE;
        }
        Type[] genericTypes = typeArray;
        return this.initElementsContainer(driver, field, self, field.getType(), genericTypes);
    }

    @Override
    public Container initElementsContainer(Driver driver, Field field, WebElementSource self, Class<?> type, Type[] genericTypes) throws ReflectiveOperationException {
        if (Modifier.isInterface(type.getModifiers())) {
            throw new IllegalArgumentException("Cannot initialize field " + String.valueOf(field) + ": " + String.valueOf(type) + " is interface");
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalArgumentException("Cannot initialize field " + String.valueOf(field) + ": " + String.valueOf(type) + " is abstract");
        }
        Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        Container result = (Container)constructor.newInstance(new Object[0]);
        this.initElements(driver, self, result, genericTypes);
        return result;
    }

    private @Nullable String alias(Field field) {
        As alias = SelenidePageFactory.aliasOf(field);
        return alias == null ? null : alias.value();
    }

    public @Nullable Object decorate(ClassLoader loader, Driver driver, @Nullable WebElementSource searchContext, Field field, By selector, Type[] genericTypes) {
        String alias = this.alias(field);
        if (field.isAnnotationPresent(Container.Self.class)) {
            return this.injectSelf(searchContext, field);
        }
        if (WebElement.class.isAssignableFrom(field.getType())) {
            return this.decorateWebElement(driver, searchContext, selector, field, alias);
        }
        if (BaseElementsCollection.class.isAssignableFrom(field.getType())) {
            return this.createElementsCollection(driver, searchContext, selector, field, alias);
        }
        if (field.getType().isAssignableFrom(ElementsList.class) && this.isCollectionOfSelenideElements(field, genericTypes)) {
            return this.createElementsCollection(driver, searchContext, selector, field, alias);
        }
        if (Container.class.isAssignableFrom(field.getType())) {
            return this.createElementsContainer(driver, searchContext, field, selector);
        }
        if (this.isDecoratableList(field, selector, genericTypes, Container.class)) {
            return this.createElementsContainerList(driver, searchContext, field, genericTypes, selector);
        }
        if (this.isDecoratableList(field, selector, genericTypes, WebElement.class)) {
            return this.createElementsCollection(driver, searchContext, selector, field, alias);
        }
        return this.defaultFieldDecorator(driver, searchContext).decorate(loader, field);
    }

    private boolean isCollectionOfSelenideElements(Field field, Type[] genericTypes) {
        Class<?> listGenericType = this.getListGenericType(field, genericTypes);
        return listGenericType != null && SelenideElement.class.isAssignableFrom(listGenericType);
    }

    private SelenideElement injectSelf(@Nullable WebElementSource searchContext, Field field) {
        if (searchContext != null) {
            return this.createSelf(searchContext, this.getTargetType(field));
        }
        String message = String.format("Cannot initialize field %s.%s: it's not bound to any page object", field.getDeclaringClass().getSimpleName(), field.getName());
        throw new IllegalArgumentException(message);
    }

    protected <T extends SelenideElement> SelenideElement createSelf(WebElementSource searchContext, Class<T> targetType) {
        return ElementFinder.wrap(targetType, searchContext);
    }

    protected SelenideElement decorateWebElement(Driver driver, @Nullable WebElementSource searchContext, By selector, Field field, @Nullable String alias) {
        return this.shouldCache(field) ? LazyWebElementSnapshot.wrap(this.getTargetType(field), new ElementFinder(driver, searchContext, selector, 0, alias)) : ElementFinder.wrap(driver, this.getTargetType(field), searchContext, selector, 0, alias);
    }

    protected BaseElementsCollection<? extends SelenideElement, ? extends BaseElementsCollection<?, ?>> createElementsCollection(Driver driver, @Nullable WebElementSource searchContext, By selector, Field field, @Nullable String alias) {
        CollectionSource collection = new BySelectorCollection(driver, searchContext, selector);
        if (alias != null) {
            collection.setAlias(alias);
        }
        if (this.shouldCache(field)) {
            collection = new LazyCollectionSnapshot(collection);
        }
        return this.createCollection(collection, field.getType());
    }

    protected BaseElementsCollection<? extends SelenideElement, ? extends BaseElementsCollection<?, ?>> createCollection(CollectionSource collection, Class<?> klass) {
        return new ElementsList(collection);
    }

    protected FieldDecorator defaultFieldDecorator(Driver driver, @Nullable WebElementSource searchContext) {
        return new DefaultFieldDecorator((ElementLocatorFactory)this.fieldLocatorFactory(driver, searchContext));
    }

    private DefaultElementLocatorFactory fieldLocatorFactory(Driver driver, @Nullable WebElementSource searchContext) {
        SearchContext context = this.getSearchContext(driver, searchContext);
        return new DefaultElementLocatorFactory(context);
    }

    protected SearchContext getSearchContext(Driver driver, @Nullable WebElementSource searchContext) {
        return searchContext == null ? driver.getWebDriver() : searchContext.getWebElement();
    }

    protected List<Container> createElementsContainerList(Driver driver, @Nullable WebElementSource searchContext, Field field, Type[] genericTypes, By selector) {
        Class<?> listType = this.getListGenericType(field, genericTypes);
        if (listType == null) {
            throw new IllegalArgumentException("Cannot detect list type for " + String.valueOf(field));
        }
        CollectionSource collection = new BySelectorCollection(driver, searchContext, selector);
        if (this.shouldCache(field)) {
            collection = new LazyCollectionSnapshot(collection);
        }
        return new ElementsContainerCollection(this, driver, field, listType, genericTypes, collection);
    }

    protected boolean isDecoratableList(Field field, @Nullable By selector, Type[] genericTypes, Class<?> type) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Class<?> listType = this.getListGenericType(field, genericTypes);
        return listType != null && type.isAssignableFrom(listType) && selector != null;
    }

    protected @Nullable Class<?> getListGenericType(Field field, Type[] genericTypes) {
        Type fieldType = field.getGenericType();
        if (!(fieldType instanceof ParameterizedType)) {
            return null;
        }
        Type[] actualTypeArguments = ((ParameterizedType)fieldType).getActualTypeArguments();
        Type firstType = actualTypeArguments[0];
        if (firstType instanceof TypeVariable) {
            int indexOfType = this.indexOf(field.getDeclaringClass(), firstType);
            return (Class)genericTypes[indexOfType];
        }
        if (firstType instanceof Class) {
            Class classType = (Class)firstType;
            return classType;
        }
        throw new IllegalArgumentException("Cannot detect list type of " + String.valueOf(field));
    }

    protected int indexOf(Class<?> klass, Type firstArgument) {
        Object[] objects = Arrays.stream(klass.getTypeParameters()).toArray();
        int typeParameterCount = objects.length;
        for (int i = 0; i < typeParameterCount; ++i) {
            if (!objects[i].equals(firstArgument)) continue;
            return i;
        }
        return -1;
    }

    private static @Nullable As aliasOf(Field field) {
        return field.getAnnotation(As.class);
    }

    private <T extends SelenideElement> Class<T> getTargetType(Field field) {
        Class<?> result;
        if (this.elementsBaseType().isAssignableFrom(field.getType())) {
            result = field.getType();
        } else if (field.getType().isAssignableFrom(this.elementsBaseType())) {
            result = this.elementsBaseType();
        } else {
            throw new IllegalArgumentException("%s or subclasses are supported as type for page factory. Field name: %s, provided class: %s".formatted(this.elementsBaseType().getName(), field.getName(), field.getType()));
        }
        return result;
    }

    protected Class<?> elementsBaseType() {
        return SelenideElement.class;
    }

    private static class ElementsList
    extends ElementsCollection
    implements NoOpsList<SelenideElement> {
        ElementsList(CollectionSource collection) {
            super(collection);
        }
    }
}

