/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Container;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.PageObjectException;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.PageObjectFactory;
import com.codeborne.selenide.impl.SelenidePageFactory;
import com.codeborne.selenide.impl.WebElementWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.AbstractList;
import org.openqa.selenium.NoSuchElementException;

public class ElementsContainerCollection
extends AbstractList<Container> {
    private final PageObjectFactory pageFactory;
    private final Driver driver;
    private final Field field;
    private final Class<?> listType;
    private final Type[] genericTypes;
    private final CollectionSource collection;

    public ElementsContainerCollection(PageObjectFactory pageFactory, Driver driver, Field field, Class<?> listType, Type[] genericTypes, CollectionSource collection) {
        this.pageFactory = pageFactory;
        this.driver = driver;
        this.field = field;
        this.listType = listType;
        this.genericTypes = genericTypes;
        this.collection = collection;
    }

    @Override
    public Container get(int index) {
        String searchCriteria = String.format("%s[%s]", this.collection.getSearchCriteria(), index);
        WebElementWrapper self = new WebElementWrapper(this.driver, this.collection.getElement(index), searchCriteria, SelenidePageFactory.isShadowRoot(this.field, this.listType));
        try {
            return this.pageFactory.initElementsContainer(this.driver, this.field, self, this.listType, this.genericTypes);
        }
        catch (ReflectiveOperationException e) {
            throw new PageObjectException("Failed to initialize field " + String.valueOf(this.field), e);
        }
    }

    @Override
    public int size() {
        try {
            return this.collection.getElements().size();
        }
        catch (NoSuchElementException e) {
            throw UIAssertionError.wrap(this.driver, (Error)((Object)new ElementNotFound(Alias.NONE, this.collection.getSearchCriteria(), Condition.exist, (Throwable)e)), 0L);
        }
    }

    @Override
    public String toString() {
        return this.collection.description();
    }
}

