/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.conditions.Not;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

public class Hidden
extends WebElementCondition {
    public Hidden() {
        super("hidden", true);
    }

    @Override
    public CheckResult check(Driver driver, WebElement element) {
        try {
            boolean hidden = !element.isDisplayed();
            return new CheckResult(hidden, (Object)(hidden ? "hidden" : "visible"));
        }
        catch (NoSuchElementException | StaleElementReferenceException elementHasDisappeared) {
            return new CheckResult(CheckResult.Verdict.ACCEPT, (Object)"hidden:true");
        }
    }

    @Override
    public WebElementCondition negate() {
        return new Not(this, false);
    }
}

