/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.FluentCommand;
import com.codeborne.selenide.ScrollDirection;
import com.codeborne.selenide.ScrollOptions;
import com.codeborne.selenide.impl.WebElementSource;
import org.openqa.selenium.WebElement;

public class Scroll
extends FluentCommand {
    @Override
    protected void execute(WebElementSource locator, Object[] args) {
        ScrollOptions options = this.extractOptions(args);
        WebElement webElement = locator.getWebElement();
        int distance = options.distance();
        String js = switch (options.direction()) {
            default -> throw new IncompatibleClassChangeError();
            case ScrollDirection.DOWN -> "arguments[0].scrollBy(0, arguments[1])";
            case ScrollDirection.UP -> "arguments[0].scrollBy(0, -arguments[1])";
            case ScrollDirection.RIGHT -> "arguments[0].scrollBy(arguments[1], 0)";
            case ScrollDirection.LEFT -> "arguments[0].scrollBy(-arguments[1], 0)";
        };
        locator.driver().executeJavaScript(js, webElement, distance);
    }

    protected ScrollOptions extractOptions(Object[] args) {
        Object object = args[0];
        if (object instanceof ScrollOptions) {
            ScrollOptions options = (ScrollOptions)object;
            return options;
        }
        return ScrollOptions.defaultScrollOptions();
    }
}

