/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.WebElementsCondition;
import com.codeborne.selenide.ex.ElementWithTextNotFound;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementCommunicator;
import com.codeborne.selenide.impl.Plugins;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class ItemWithText
extends WebElementsCondition {
    private static final ElementCommunicator communicator = Plugins.inject(ElementCommunicator.class);
    private final String expectedText;

    public ItemWithText(String expectedText) {
        this.expectedText = expectedText;
    }

    @Override
    public CheckResult check(CollectionSource collection) {
        List<WebElement> elements = collection.getElements();
        List<String> texts = communicator.texts(collection.driver(), elements);
        return new CheckResult(texts.contains(this.expectedText), texts);
    }

    @Override
    public void fail(CollectionSource collection, CheckResult lastCheckResult, @Nullable Exception cause, long timeoutMs) {
        throw new ElementWithTextNotFound(collection, Collections.singletonList(this.expectedText), (List)lastCheckResult.getActualValue(), this.explanation, timeoutMs, cause);
    }

    @Override
    public String toString() {
        return "Text " + this.expectedText;
    }
}

