/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.SetValueMethod;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.regex.Pattern;

public class SetValueOptions {
    private static final Pattern REGEX_ANY_CHAR = Pattern.compile(".");
    private static final Formats DATE = new Formats(DateTimeFormatter.ofPattern("yyyy-MM-dd"), DateTimeFormatter.ofPattern("dd.MM.yyyy"));
    private static final Formats DATETIME = new Formats(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS"), DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm"));
    private static final Formats TIME = new Formats(DateTimeFormatter.ofPattern("HH:mm:ss.SSS"), DateTimeFormatter.ofPattern("HH:mm"));
    private final CharSequence value;
    private final CharSequence displayedText;
    private final SetValueMethod method;

    protected SetValueOptions(SetValueMethod method, CharSequence value, CharSequence displayedText) {
        this.method = method;
        this.value = value;
        this.displayedText = displayedText;
    }

    public static SetValueOptions withText(CharSequence text) {
        return new SetValueOptions(SetValueMethod.SEND_KEYS, text, text);
    }

    public static SetValueOptions withDate(LocalDate date) {
        return new SetValueOptions(SetValueMethod.JS, DATE.value(date), DATE.display(date));
    }

    public static SetValueOptions withDateTime(LocalDateTime dateTime) {
        return new SetValueOptions(SetValueMethod.JS, DATETIME.value(dateTime), DATETIME.display(dateTime));
    }

    public static SetValueOptions withTime(LocalTime time) {
        return new SetValueOptions(SetValueMethod.JS, TIME.value(time), TIME.display(time));
    }

    public SetValueOptions withDisplayedText(CharSequence displayedText) {
        return new SetValueOptions(this.method, this.value, displayedText);
    }

    public SetValueOptions usingMethod(SetValueMethod method) {
        return new SetValueOptions(method, this.value, this.displayedText);
    }

    public CharSequence value() {
        return this.value;
    }

    public SetValueMethod method() {
        return this.method;
    }

    public SetValueOptions sensitive() {
        return new SetValueOptions(this.method, this.value, this.mask(this.value));
    }

    private String mask(CharSequence text) {
        return REGEX_ANY_CHAR.matcher(text).replaceAll("*");
    }

    public String toString() {
        if (this.method == SetValueMethod.SEND_KEYS) {
            return this.displayedText.toString();
        }
        return String.format("\"%s\" (feat. %s)", new Object[]{this.displayedText, this.method});
    }

    private record Formats(DateTimeFormatter valueFormat, DateTimeFormatter displayFormat) {
        String value(TemporalAccessor date) {
            return this.valueFormat.format(date);
        }

        String display(TemporalAccessor date) {
            return this.displayFormat.format(date);
        }
    }
}

