/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import com.browserup.bup.filters.RequestFilter;
import com.browserup.bup.filters.ResponseFilter;
import com.browserup.bup.util.HttpMessageContents;
import com.browserup.bup.util.HttpMessageInfo;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.files.DownloadedFile;
import com.codeborne.selenide.impl.Downloader;
import com.codeborne.selenide.impl.Downloads;
import com.codeborne.selenide.impl.HttpHelper;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class FileDownloadFilter
implements RequestFilter,
ResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadFilter.class);
    private final Config config;
    private final Downloader downloader;
    private final HttpHelper httpHelper = new HttpHelper();
    private boolean active;
    private final Downloads downloads = new Downloads();
    private final List<Response> responses = new CopyOnWriteArrayList<Response>();

    public FileDownloadFilter(Config config) {
        this(config, new Downloader());
    }

    FileDownloadFilter(Config config, Downloader downloader) {
        this.config = config;
        this.downloader = downloader;
    }

    public void activate() {
        this.reset();
        this.active = true;
    }

    public void reset() {
        this.downloads.clear();
        this.responses.clear();
    }

    public void deactivate() {
        this.active = false;
    }

    public HttpResponse filterRequest(HttpRequest request, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        if (this.active) {
            request.headers().set("Accept-Encoding", (Object)"identity");
        }
        return null;
    }

    public void filterResponse(HttpResponse response, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        if (!this.active) {
            return;
        }
        Response r = new Response(messageInfo.getUrl(), response.status().code(), response.status().reasonPhrase(), this.toMap(response.headers()), contents.getContentType(), contents.getTextContents());
        this.responses.add(r);
        log.debug("Intercepted response #{}: {}", (Object)this.responses.size(), (Object)r);
        if (response.status().code() < 200 || response.status().code() >= 300) {
            return;
        }
        String fileName = this.getFileName(r);
        File file = this.downloader.prepareTargetFile(this.config, fileName);
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])contents.getBinaryContents());
            this.downloads.add(new DownloadedFile(file, r.headers));
        }
        catch (IOException e) {
            log.error("Failed to save downloaded file to {} for url {}", new Object[]{file.getAbsolutePath(), messageInfo.getUrl(), e});
        }
    }

    private Map<String, String> toMap(HttpHeaders headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry header : headers) {
            map.put(((String)header.getKey()).toLowerCase(Locale.ROOT), (String)header.getValue());
        }
        return map;
    }

    @CheckReturnValue
    @Nonnull
    public Downloads downloads() {
        return this.downloads;
    }

    @CheckReturnValue
    @Nonnull
    private String getFileName(Response response) {
        return this.httpHelper.getFileNameFromContentDisposition(response.headers).map(this.httpHelper::normalize).orElseGet(() -> {
            log.info("Cannot extract file name from http headers for {}. Found headers: {}", (Object)response.url, (Object)response.headers);
            String fileNameFromUrl = this.httpHelper.getFileName(response.url);
            String result = StringUtils.isNotBlank((CharSequence)fileNameFromUrl) ? fileNameFromUrl : this.downloader.randomFileName();
            log.info("Generated file name for {}: {}", (Object)response.url, (Object)result);
            return result;
        });
    }

    @CheckReturnValue
    @Nonnull
    public String responsesAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.responses.size()).append(" responses:\n");
        int i = 0;
        for (Response response : this.responses) {
            sb.append("  #").append(++i).append("  ").append(response).append("\n");
        }
        return sb.toString();
    }

    @ParametersAreNonnullByDefault
    private static class Response {
        private final String url;
        private final int code;
        private final String reasonPhrase;
        private final String contentType;
        private final Map<String, String> headers;
        private final String content;

        private Response(String url, int code, String reasonPhrase, Map<String, String> headers, String contentType, String content) {
            this.url = url;
            this.code = code;
            this.reasonPhrase = reasonPhrase;
            this.headers = headers;
            this.contentType = contentType;
            this.content = content;
        }

        @CheckReturnValue
        @Nonnull
        public String toString() {
            return this.url + " -> " + this.code + " \"" + this.reasonPhrase + "\" " + this.headers + " " + this.contentType + "  (" + this.content.length() + " bytes)";
        }
    }
}

