/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import com.browserup.bup.filters.RequestFilter;
import com.browserup.bup.util.HttpMessageContents;
import com.browserup.bup.util.HttpMessageInfo;
import com.codeborne.selenide.AuthenticationType;
import com.codeborne.selenide.Credentials;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AuthenticationFilter
implements RequestFilter {
    private AuthenticationType authenticationType;
    private Credentials credentials;

    @Nullable
    public HttpResponse filterRequest(HttpRequest request, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        if (this.authenticationType != null && this.needsHeader(messageInfo.getUrl())) {
            String authorization = String.format("%s %s", this.authenticationType.getValue(), this.credentials.encode());
            HttpHeaders headers = request.headers();
            headers.add("Authorization", (Object)authorization);
            headers.add("Proxy-Authorization", (Object)authorization);
        }
        return null;
    }

    boolean needsHeader(String url) {
        if (this.credentials.domain().isEmpty()) {
            return true;
        }
        String host = this.getHostname(url);
        return host != null && host.equalsIgnoreCase(this.credentials.domain());
    }

    String getHostname(String url) {
        try {
            return new URI(url).getHost();
        }
        catch (URISyntaxException invalidUri) {
            return url;
        }
    }

    public void setAuthentication(@Nullable AuthenticationType authenticationType, @Nullable Credentials credentials) {
        this.authenticationType = authenticationType;
        this.credentials = credentials;
    }

    public void removeAuthentication() {
        this.setAuthentication(null, null);
    }
}

