/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.AssertionMode;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.ex.SoftAssertionError;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ErrorsCollector
implements LogEventListener {
    public static final String LISTENER_SOFT_ASSERT = "softAssert";
    private final List<Throwable> errors = new ArrayList<Throwable>();

    protected boolean isEnabled() {
        return true;
    }

    @Override
    public void afterEvent(LogEvent event) {
        if (this.isEnabled() && event.getStatus() == LogEvent.EventStatus.FAIL) {
            this.errors.add(event.getError());
        }
    }

    @Override
    public void beforeEvent(LogEvent currentLog) {
    }

    void clear() {
        this.errors.clear();
    }

    List<Throwable> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    @Nullable
    public AssertionError cleanAndGetAssertionError(String testName, @Nullable Throwable testFailure) {
        Object e;
        ArrayList<Throwable> errors = new ArrayList<Throwable>(this.errors);
        if (testFailure != null) {
            errors.add(testFailure);
        }
        this.errors.clear();
        if (errors.size() == 1 && (e = errors.get(0)) instanceof AssertionError) {
            AssertionError assertionError = (AssertionError)e;
            return assertionError;
        }
        if (!errors.isEmpty()) {
            String message = String.format("Test %s failed", testName);
            return new SoftAssertionError(message, errors);
        }
        return null;
    }

    public void cleanAndThrowAssertionError(String testName, @Nullable Throwable testFailure) {
        AssertionError error = this.cleanAndGetAssertionError(testName, testFailure);
        if (error != null) {
            throw error;
        }
    }

    public static void validateAssertionMode(Config config) {
        if (config.assertionMode() == AssertionMode.SOFT && !SelenideLogger.hasListener(LISTENER_SOFT_ASSERT)) {
            throw new IllegalStateException("You must configure you classes using JUnit4/JUnit5/TestNG mechanism as documented in https://github.com/selenide/selenide/wiki/SoftAssertions");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.errors + "]";
    }
}

