/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.AssertionMode;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.commands.Commands;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.Arguments;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.ExceptionWrapper;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.WebDriverException;

@ParametersAreNonnullByDefault
class SelenideElementProxy
implements InvocationHandler {
    private static final Set<String> methodsToSkipLogging = new HashSet<String>(Arrays.asList("as", "getAlias", "toWebElement", "toString", "getSearchCriteria", "$", "$x", "find", "$$", "$$x", "findAll", "parent", "sibling", "preceding", "lastChild", "closest", "ancestor"));
    private static final Set<String> methodsForSoftAssertion = new HashSet<String>(Arrays.asList("should", "shouldBe", "shouldHave", "shouldNot", "shouldNotHave", "shouldNotBe"));
    private final WebElementSource webElementSource;
    private final ExceptionWrapper exceptionWrapper = new ExceptionWrapper();

    protected SelenideElementProxy(WebElementSource webElementSource) {
        this.webElementSource = webElementSource;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object ... args) throws Throwable {
        Arguments arguments = new Arguments(args);
        if (methodsToSkipLogging.contains(method.getName())) {
            return Commands.getInstance().execute(proxy, this.webElementSource, method.getName(), args);
        }
        if (this.isMethodForSoftAssertion(method)) {
            ErrorsCollector.validateAssertionMode(this.config());
        }
        long timeoutMs = arguments.getTimeoutMs(this.config().timeout());
        SelenideLog log = SelenideLogger.beginStep(this.webElementSource.description(), method.getName(), args);
        try {
            Object result = this.dispatchAndRetry(timeoutMs, this.config().pollingInterval(), proxy, method, args);
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
            return result;
        }
        catch (Error error) {
            Error wrappedError = UIAssertionError.wrap(this.driver(), error, timeoutMs);
            SelenideLogger.commitStep(log, wrappedError);
            return this.continueOrBreak(proxy, method, wrappedError);
        }
        catch (WebDriverException error) {
            Throwable wrappedError = UIAssertionError.wrap(this.driver(), error, timeoutMs);
            SelenideLogger.commitStep(log, wrappedError);
            return this.continueOrBreak(proxy, method, wrappedError);
        }
        catch (IOException | RuntimeException error) {
            SelenideLogger.commitStep(log, error);
            throw error;
        }
    }

    @Nonnull
    private Object continueOrBreak(Object proxy, Method method, Throwable wrappedError) throws Throwable {
        if (this.config().assertionMode() == AssertionMode.SOFT && this.isMethodForSoftAssertion(method)) {
            return proxy;
        }
        throw wrappedError;
    }

    private boolean isMethodForSoftAssertion(Method method) {
        return methodsForSoftAssertion.contains(method.getName());
    }

    private Driver driver() {
        return this.webElementSource.driver();
    }

    private Config config() {
        return this.driver().config();
    }

    protected Object dispatchAndRetry(long timeoutMs, long pollingIntervalMs, Object proxy, Method method, @Nullable Object[] args) throws Throwable {
        Object lastError;
        Stopwatch stopwatch = new Stopwatch(timeoutMs);
        do {
            try {
                if (SelenideElementProxy.isSelenideElementMethod(method)) {
                    return Commands.getInstance().execute(proxy, this.webElementSource, method.getName(), args);
                }
                return method.invoke((Object)this.webElementSource.getWebElement(), args);
            }
            catch (InvocationTargetException e) {
                lastError = e.getTargetException();
            }
            catch (AssertionError | IndexOutOfBoundsException | WebDriverException e) {
                lastError = e;
            }
            if (Cleanup.of.isInvalidSelectorError((Throwable)lastError)) {
                throw Cleanup.of.wrapInvalidSelectorException((Throwable)lastError);
            }
            if (!SelenideElementProxy.shouldRetryAfterError((Throwable)lastError)) {
                throw lastError;
            }
            stopwatch.sleep(pollingIntervalMs);
        } while (!stopwatch.isTimeoutReached());
        throw this.exceptionWrapper.wrap((Throwable)lastError, this.webElementSource);
    }

    @CheckReturnValue
    static boolean isSelenideElementMethod(Method method) {
        return SelenideElement.class.isAssignableFrom(method.getDeclaringClass());
    }

    @CheckReturnValue
    static boolean shouldRetryAfterError(Throwable e) {
        if (e instanceof FileNotFoundException) {
            return false;
        }
        if (e instanceof IllegalArgumentException) {
            return false;
        }
        if (e instanceof ReflectiveOperationException) {
            return false;
        }
        if (e instanceof JavascriptException) {
            return false;
        }
        return e instanceof Exception || e instanceof AssertionError;
    }
}

