/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class LazyCollectionSnapshot
implements CollectionSource {
    private final CollectionSource delegate;
    private List<WebElement> elementsSnapshot;

    LazyCollectionSnapshot(CollectionSource delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public List<WebElement> getElements() {
        if (this.elementsSnapshot == null) {
            this.elementsSnapshot = new ArrayList<WebElement>(this.delegate.getElements());
        }
        return this.elementsSnapshot;
    }

    @Override
    @Nonnull
    public WebElement getElement(int index) {
        return this.getElements().get(index);
    }

    @Override
    @Nonnull
    public String getSearchCriteria() {
        return this.delegate.getSearchCriteria();
    }

    @Override
    @Nonnull
    public Driver driver() {
        return this.delegate.driver();
    }

    @Override
    @Nonnull
    public Alias getAlias() {
        return this.delegate.getAlias();
    }

    @Override
    public void setAlias(String alias) {
        this.delegate.setAlias(alias);
    }
}

