/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsContainer;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.PageObjectException;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.PageObjectFactory;
import com.codeborne.selenide.impl.WebElementWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.AbstractList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.NoSuchElementException;

@ParametersAreNonnullByDefault
public class ElementsContainerCollection
extends AbstractList<ElementsContainer> {
    private final PageObjectFactory pageFactory;
    private final Driver driver;
    private final Field field;
    private final Class<?> listType;
    private final Type[] genericTypes;
    private final CollectionSource collection;

    public ElementsContainerCollection(PageObjectFactory pageFactory, Driver driver, Field field, Class<?> listType, Type[] genericTypes, CollectionSource collection) {
        this.pageFactory = pageFactory;
        this.driver = driver;
        this.field = field;
        this.listType = listType;
        this.genericTypes = genericTypes;
        this.collection = collection;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public ElementsContainer get(int index) {
        WebElementWrapper self = new WebElementWrapper(this.driver, this.collection.getElement(index));
        try {
            return this.pageFactory.initElementsContainer(this.driver, this.field, self, this.listType, this.genericTypes);
        }
        catch (ReflectiveOperationException e) {
            throw new PageObjectException("Failed to initialize field " + this.field, e);
        }
    }

    @Override
    @CheckReturnValue
    public int size() {
        try {
            return this.collection.getElements().size();
        }
        catch (NoSuchElementException e) {
            throw new ElementNotFound(Alias.NONE, this.collection.getSearchCriteria(), Condition.exist, (Throwable)e);
        }
    }
}

