/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementDescriber;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.WebElementSelector;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class BySelectorCollection
implements CollectionSource {
    private final WebElementSelector elementSelector = Plugins.inject(WebElementSelector.class);
    private final ElementDescriber describe = Plugins.inject(ElementDescriber.class);
    private final Driver driver;
    private final WebElementSource parent;
    private final By selector;
    private Alias alias = Alias.NONE;

    public BySelectorCollection(Driver driver, By selector) {
        this(driver, null, selector);
    }

    public BySelectorCollection(Driver driver, @Nullable WebElementSource parent, By selector) {
        this.driver = driver;
        this.parent = parent;
        this.selector = selector;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> getElements() {
        return this.elementSelector.findElements(this.driver, this.parent, this.selector);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getElement(int index) {
        return this.elementSelector.findElement(this.driver, this.parent, this.selector, index);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getSearchCriteria() {
        return this.parent == null ? this.describe.selector(this.selector) : this.parent.getSearchCriteria() + "/" + this.describe.selector(this.selector);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.driver;
    }

    @Override
    @Nonnull
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }
}

