/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.TextCheck;
import com.codeborne.selenide.impl.Html;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Value
extends Condition {
    private final String expectedValue;

    public Value(String expectedValue) {
        super("value");
        this.expectedValue = expectedValue;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, WebElement element) {
        String value = this.getValueAttribute(element);
        String actualValue = String.format("%s=\"%s\"", this.getName(), value);
        return new CheckResult(this.match(driver.config().textCheck(), value), (Object)actualValue);
    }

    private boolean match(TextCheck textCheck, String value) {
        boolean bl;
        switch (textCheck) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case FULL_TEXT: {
                bl = Html.text.equals(value, this.expectedValue);
                break;
            }
            case PARTIAL_TEXT: {
                bl = Html.text.contains(value, this.expectedValue);
            }
        }
        return bl;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String toString() {
        return String.format("%s=\"%s\"", this.getName(), this.expectedValue);
    }

    private String getValueAttribute(WebElement element) {
        String attr = element.getAttribute("value");
        return attr == null ? "" : attr;
    }
}

