/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.TextCheck;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public abstract class TextCondition
extends Condition {
    private final String expectedText;

    protected TextCondition(String name, String expectedText) {
        super(name);
        this.expectedText = expectedText;
    }

    @CheckReturnValue
    protected abstract boolean match(String var1, String var2);

    protected boolean match(TextCheck textCheck, String actualText, String expectedText) {
        return this.match(actualText, expectedText);
    }

    @Nullable
    @CheckReturnValue
    protected String getText(Driver driver, WebElement element) {
        return element.getText();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, WebElement element) {
        String elementText = this.getText(driver, element);
        boolean match = this.match(driver.config().textCheck(), elementText, this.expectedText);
        return new CheckResult(match, (Object)String.format("text=\"%s\"", elementText));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public final String toString() {
        return String.format("%s \"%s\"", this.getName(), this.expectedText);
    }
}

