/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class MatchAttributeWithValue
extends Condition {
    private final String attributeName;
    private final Pattern attributeRegex;

    public MatchAttributeWithValue(String attributeName, String attributeRegex) {
        super("match attribute");
        this.attributeName = attributeName;
        this.attributeRegex = Pattern.compile(attributeRegex);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, WebElement element) {
        String attributeValue = this.getAttributeValue(element);
        return new CheckResult(this.attributeRegex.matcher(attributeValue).matches(), (Object)String.format("%s~/%s/", this.attributeName, attributeValue));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String toString() {
        return String.format("%s %s~/%s/", this.getName(), this.attributeName, this.attributeRegex);
    }

    private String getAttributeValue(WebElement element) {
        String attr = element.getAttribute(this.attributeName);
        return attr == null ? "" : attr;
    }
}

