/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.conditions.Not;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class And
extends Condition {
    private final List<? extends Condition> conditions;

    public And(String name, List<? extends Condition> conditions) {
        super(name, And.checkedConditionsListCtorArg(conditions).stream().allMatch(Condition::missingElementSatisfiesCondition));
        this.conditions = conditions;
    }

    private static List<? extends Condition> checkedConditionsListCtorArg(List<? extends Condition> conditions) {
        if (conditions.isEmpty()) {
            throw new IllegalArgumentException("conditions list is empty");
        }
        return conditions;
    }

    @Override
    @Nonnull
    public Condition negate() {
        return new Not(this, this.conditions.stream().map(Condition::negate).allMatch(Condition::missingElementSatisfiesCondition));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, WebElement element) {
        ArrayList<CheckResult> results = new ArrayList<CheckResult>();
        for (Condition condition : this.conditions) {
            CheckResult checkResult = condition.check(driver, element);
            if (checkResult.verdict() != CheckResult.Verdict.ACCEPT) {
                return checkResult;
            }
            results.add(checkResult);
        }
        String actualValues = results.stream().map(check -> String.valueOf(check.actualValue())).collect(Collectors.joining(", "));
        return new CheckResult(CheckResult.Verdict.ACCEPT, (Object)actualValues);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String toString() {
        return this.getName() + ": " + this.conditions.stream().map(Condition::toString).collect(Collectors.joining(" and "));
    }
}

