/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Condition;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Util {
    @CheckReturnValue
    @Nonnull
    public static <T> T firstOf(@Nullable Object[] args) {
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("Missing arguments");
        }
        return (T)args[0];
    }

    @CheckReturnValue
    @Nonnull
    public static List<Condition> argsToConditions(@Nullable Object[] args) {
        if (args == null) {
            return Collections.emptyList();
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>(args.length);
        for (Object arg : args) {
            if (arg instanceof Condition) {
                Condition conditionArgument = (Condition)arg;
                conditions.add(conditionArgument);
                continue;
            }
            if (arg instanceof Condition[]) {
                Condition[] conditionsArray = (Condition[])arg;
                conditions.addAll(Arrays.asList(conditionsArray));
                continue;
            }
            if (arg instanceof String || arg instanceof Long || arg instanceof Duration) continue;
            throw new IllegalArgumentException("Unknown parameter: " + arg);
        }
        return conditions;
    }

    @CheckReturnValue
    @Nonnull
    @SafeVarargs
    public static <T> List<T> merge(T first, T ... others) {
        ArrayList<T> result = new ArrayList<T>(1 + others.length);
        result.add(first);
        result.addAll(Arrays.asList(others));
        return Collections.unmodifiableList(result);
    }

    @CheckReturnValue
    @Nonnull
    public static List<Integer> merge(int first, int[] others) {
        ArrayList<Integer> result = new ArrayList<Integer>(1 + others.length);
        result.add(first);
        IntStream.of(others).forEach(i -> result.add(i));
        return Collections.unmodifiableList(result);
    }

    public static <T> T cast(Object value) {
        return (T)value;
    }

    public static <T> String arrayToString(List<T> values) {
        return values.stream().map(Objects::toString).collect(Collectors.joining(","));
    }
}

