/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.InvalidStateException;
import com.codeborne.selenide.impl.Arguments;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SelectOptionByValue
implements Command<Void> {
    private static final JavaScript selectOptionByValue = new JavaScript("select-options-by-value.js");

    @Override
    @Nullable
    public Void execute(SelenideElement proxy, WebElementSource selectField, @Nullable Object[] args) {
        Arguments arguments = new Arguments(args);
        List<String> values = Util.merge((String)arguments.nth(0), (String[])arguments.nth(1));
        this.selectOptionByValue(selectField, values);
        return null;
    }

    private void selectOptionByValue(WebElementSource selectField, List<String> values) {
        Map error = (Map)selectOptionByValue.execute(selectField.driver(), selectField.getWebElement(), values);
        if (error.containsKey("disabledSelect")) {
            throw new InvalidStateException(selectField.description(), "Cannot select option in a disabled select");
        }
        if (error.containsKey("disabledOptions")) {
            List value = (List)Util.cast(error.get("disabledOptions"));
            String elementDescription = String.format("%s/option[value:%s]", selectField.description(), Util.arrayToString(value));
            throw new InvalidStateException(elementDescription, "Cannot select a disabled option");
        }
        if (error.containsKey("optionsNotFound")) {
            List value = (List)Util.cast(error.get("optionsNotFound"));
            String elementDescription = String.format("%s/option[value:%s]", selectField.getSearchCriteria(), Util.arrayToString(value));
            throw new ElementNotFound(selectField.getAlias(), elementDescription, Condition.exist);
        }
    }
}

