/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.impl.HasTimeout;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ModalOptions
implements HasTimeout {
    @Nullable
    private final String expectedText;
    @Nullable
    private final Duration timeout;

    public ModalOptions(@Nullable String expectedText, @Nullable Duration timeout) {
        this.expectedText = expectedText;
        this.timeout = timeout;
    }

    @CheckReturnValue
    @Nonnull
    public static ModalOptions none() {
        return new ModalOptions(null, null);
    }

    @CheckReturnValue
    @Nonnull
    public static ModalOptions withExpectedText(@Nullable String expectedText) {
        return new ModalOptions(expectedText, null);
    }

    @CheckReturnValue
    @Nonnull
    public static ModalOptions withTimeout(Duration timeout) {
        return new ModalOptions(null, timeout);
    }

    @CheckReturnValue
    @Nonnull
    public ModalOptions timeout(Duration timeout) {
        return new ModalOptions(this.expectedText, timeout);
    }

    public String toString() {
        if (this.expectedText == null && this.timeout == null) {
            return "";
        }
        if (this.expectedText == null) {
            return String.format("timeout: %s", this.timeout);
        }
        if (this.timeout == null) {
            return String.format("expected text: \"%s\"", this.expectedText);
        }
        return String.format("expected text: \"%s\", timeout: %s ms", this.expectedText, this.timeout.toMillis());
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.expectedText != null ? this.expectedText.hashCode() : 0);
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals(((ModalOptions)arg0).expectedText, this.expectedText)) {
            return false;
        }
        return Objects.equals(((ModalOptions)arg0).timeout, this.timeout);
        {
        }
    }

    @Nullable
    public String expectedText() {
        return this.expectedText;
    }

    @Override
    @Nullable
    public Duration timeout() {
        return this.timeout;
    }
}

