/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class HoverOptions {
    private final int offsetX;
    private final int offsetY;

    private HoverOptions(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    @CheckReturnValue
    @Nonnull
    public static HoverOptions withOffset(int offsetX, int offsetY) {
        return new HoverOptions(offsetX, offsetY);
    }

    @CheckReturnValue
    public int offsetX() {
        return this.offsetX;
    }

    @CheckReturnValue
    public int offsetY() {
        return this.offsetY;
    }

    public String toString() {
        if (this.offsetX == 0 && this.offsetY == 0) {
            return "";
        }
        return String.format("offsetX: %s, offsetY: %s", this.offsetX, this.offsetY);
    }
}

