/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.files.FileFilter;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FilenameUtils;

@ParametersAreNonnullByDefault
public abstract class DownloadsFolder {
    protected final File folder;

    protected DownloadsFolder(File folder) {
        this.folder = folder.getAbsoluteFile();
    }

    @CheckReturnValue
    @Nonnull
    public File toFile() {
        return this.folder;
    }

    @CheckReturnValue
    @Nonnull
    public List<File> files() {
        File[] files = this.folder.listFiles();
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    public abstract void cleanupBeforeDownload();

    public abstract void deleteIfEmpty();

    @CheckReturnValue
    @Nonnull
    public File file(String fileName) {
        return new File(this.folder, fileName).getAbsoluteFile();
    }

    public boolean hasFiles(String extension, FileFilter excludingFilter) {
        return this.files().stream().anyMatch(file -> FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase(extension) && excludingFilter.notMatch((File)file));
    }

    public Map<String, Long> modificationTimes() {
        File[] files = this.folder.listFiles();
        return files == null ? Collections.emptyMap() : Stream.of(files).collect(Collectors.toMap(f -> f.getName(), f -> f.lastModified()));
    }

    public Optional<Long> lastModificationTime() {
        return this.modificationTimes().values().stream().max(Long::compare);
    }

    public String toString() {
        return this.folder.getPath();
    }
}

