/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.FileDownloadMode;
import com.codeborne.selenide.files.DownloadAction;
import com.codeborne.selenide.files.DownloadActions;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.files.FileFilters;
import com.codeborne.selenide.impl.HasTimeout;
import java.time.Duration;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DownloadOptions
implements HasTimeout {
    private final FileDownloadMode method;
    @Nullable
    private final Duration timeout;
    @Nullable
    private final Duration incrementTimeout;
    private final FileFilter filter;
    private final DownloadAction action;

    private DownloadOptions(FileDownloadMode method, @Nullable Duration timeout, @Nullable Duration incrementTimeout, FileFilter filter, DownloadAction action) {
        this.method = method;
        this.timeout = timeout;
        this.incrementTimeout = incrementTimeout;
        this.filter = filter;
        this.action = action;
    }

    @CheckReturnValue
    @Nonnull
    public FileDownloadMode getMethod() {
        return this.method;
    }

    @Override
    @CheckReturnValue
    public Duration timeout() {
        return this.timeout;
    }

    @CheckReturnValue
    public Duration incrementTimeout() {
        return this.incrementTimeout;
    }

    @CheckReturnValue
    @Nonnull
    public FileFilter getFilter() {
        return this.filter;
    }

    @CheckReturnValue
    @Nonnull
    public DownloadAction getAction() {
        return this.action;
    }

    @CheckReturnValue
    @Nonnull
    public DownloadOptions withTimeout(long timeoutMs) {
        return new DownloadOptions(this.method, Duration.ofMillis(timeoutMs), this.incrementTimeout, this.filter, this.action);
    }

    @CheckReturnValue
    @Nonnull
    public DownloadOptions withTimeout(Duration timeout) {
        return new DownloadOptions(this.method, timeout, this.incrementTimeout, this.filter, this.action);
    }

    @CheckReturnValue
    @Nonnull
    public DownloadOptions withIncrementTimeout(Duration incrementTimeout) {
        return new DownloadOptions(this.method, this.timeout, incrementTimeout, this.filter, this.action);
    }

    @CheckReturnValue
    @Nonnull
    public DownloadOptions withFilter(FileFilter filter) {
        return new DownloadOptions(this.method, this.timeout, this.incrementTimeout, filter, this.action);
    }

    public DownloadOptions withAction(DownloadAction action) {
        return new DownloadOptions(this.method, this.timeout, this.incrementTimeout, this.filter, action);
    }

    public String toString() {
        if (this.timeout != null && !this.filter.isEmpty()) {
            return String.format("method: %s, timeout: %s ms, filter:%s", new Object[]{this.method, this.timeout.toMillis(), this.filter.description()});
        }
        if (this.timeout != null) {
            return String.format("method: %s, timeout: %s ms", new Object[]{this.method, this.timeout.toMillis()});
        }
        if (!this.filter.isEmpty()) {
            return String.format("method: %s, filter:%s", new Object[]{this.method, this.filter.description()});
        }
        return String.format("method: %s", new Object[]{this.method});
    }

    @CheckReturnValue
    @Nonnull
    public static DownloadOptions using(FileDownloadMode method) {
        return new DownloadOptions(method, null, null, FileFilters.none(), DownloadActions.click());
    }
}

