/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.collections.AllMatch;
import com.codeborne.selenide.collections.AnyMatch;
import com.codeborne.selenide.collections.ContainExactTextsCaseSensitive;
import com.codeborne.selenide.collections.ExactTexts;
import com.codeborne.selenide.collections.ExactTextsCaseSensitive;
import com.codeborne.selenide.collections.ExactTextsCaseSensitiveInAnyOrder;
import com.codeborne.selenide.collections.ItemWithText;
import com.codeborne.selenide.collections.ListSize;
import com.codeborne.selenide.collections.NoneMatch;
import com.codeborne.selenide.collections.SizeGreaterThan;
import com.codeborne.selenide.collections.SizeGreaterThanOrEqual;
import com.codeborne.selenide.collections.SizeLessThan;
import com.codeborne.selenide.collections.SizeLessThanOrEqual;
import com.codeborne.selenide.collections.SizeNotEqual;
import com.codeborne.selenide.collections.Texts;
import com.codeborne.selenide.collections.TextsInAnyOrder;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public abstract class CollectionCondition
implements Predicate<List<WebElement>> {
    protected String explanation;
    public static CollectionCondition empty = CollectionCondition.size(0);

    public abstract void fail(CollectionSource var1, @Nullable List<WebElement> var2, @Nullable Exception var3, long var4);

    @CheckReturnValue
    public static CollectionCondition size(int expectedSize) {
        return new ListSize(expectedSize);
    }

    @CheckReturnValue
    public static CollectionCondition sizeGreaterThan(int expectedSize) {
        return new SizeGreaterThan(expectedSize);
    }

    @CheckReturnValue
    public static CollectionCondition sizeGreaterThanOrEqual(int expectedSize) {
        return new SizeGreaterThanOrEqual(expectedSize);
    }

    @CheckReturnValue
    public static CollectionCondition sizeLessThan(int expectedSize) {
        return new SizeLessThan(expectedSize);
    }

    @CheckReturnValue
    public static CollectionCondition sizeLessThanOrEqual(int size) {
        return new SizeLessThanOrEqual(size);
    }

    @CheckReturnValue
    public static CollectionCondition sizeNotEqual(int expectedSize) {
        return new SizeNotEqual(expectedSize);
    }

    @CheckReturnValue
    public static CollectionCondition texts(String ... expectedTexts) {
        return new Texts(expectedTexts);
    }

    @CheckReturnValue
    public static CollectionCondition texts(List<String> expectedTexts) {
        return new Texts(expectedTexts);
    }

    @CheckReturnValue
    public static CollectionCondition textsInAnyOrder(String ... expectedTexts) {
        return new TextsInAnyOrder(expectedTexts);
    }

    @CheckReturnValue
    public static CollectionCondition textsInAnyOrder(List<String> expectedTexts) {
        return new TextsInAnyOrder(expectedTexts);
    }

    @CheckReturnValue
    public static CollectionCondition exactTexts(String ... expectedTexts) {
        return new ExactTexts(expectedTexts);
    }

    @CheckReturnValue
    public static CollectionCondition exactTexts(List<String> expectedTexts) {
        return new ExactTexts(expectedTexts);
    }

    @CheckReturnValue
    public static CollectionCondition exactTextsCaseSensitive(String ... expectedTexts) {
        return new ExactTextsCaseSensitive(expectedTexts);
    }

    @CheckReturnValue
    public static CollectionCondition exactTextsCaseSensitive(List<String> expectedTexts) {
        return new ExactTextsCaseSensitive(expectedTexts);
    }

    @CheckReturnValue
    public static CollectionCondition anyMatch(String description, Predicate<WebElement> predicate) {
        return new AnyMatch(description, predicate);
    }

    @CheckReturnValue
    public static CollectionCondition allMatch(String description, Predicate<WebElement> predicate) {
        return new AllMatch(description, predicate);
    }

    @CheckReturnValue
    public static CollectionCondition noneMatch(String description, Predicate<WebElement> predicate) {
        return new NoneMatch(description, predicate);
    }

    @CheckReturnValue
    public static CollectionCondition itemWithText(String expectedText) {
        return new ItemWithText(expectedText);
    }

    @CheckReturnValue
    public static CollectionCondition containExactTextsCaseSensitive(String ... expectedTexts) {
        return new ContainExactTextsCaseSensitive(expectedTexts);
    }

    @CheckReturnValue
    public static CollectionCondition containExactTextsCaseSensitive(List<String> expectedTexts) {
        return new ContainExactTextsCaseSensitive(expectedTexts);
    }

    @CheckReturnValue
    public static CollectionCondition exactTextsCaseSensitiveInAnyOrder(List<String> expectedTexts) {
        return new ExactTextsCaseSensitiveInAnyOrder(expectedTexts);
    }

    @CheckReturnValue
    public static CollectionCondition exactTextsCaseSensitiveInAnyOrder(String ... expectedTexts) {
        return new ExactTextsCaseSensitiveInAnyOrder(expectedTexts);
    }

    public CollectionCondition because(String explanation) {
        this.explanation = explanation;
        return new ExplainedCollectionCondition(this, explanation);
    }

    public abstract boolean missingElementSatisfiesCondition();

    @ParametersAreNonnullByDefault
    private static class ExplainedCollectionCondition
    extends CollectionCondition {
        private final CollectionCondition delegate;
        private final String message;

        private ExplainedCollectionCondition(CollectionCondition delegate, String message) {
            this.delegate = delegate;
            this.message = message;
        }

        public String toString() {
            return this.delegate + " (because " + this.message + ")";
        }

        @Override
        public void fail(CollectionSource collection, @Nullable List<WebElement> elements, @Nullable Exception lastError, long timeoutMs) {
            this.delegate.fail(collection, elements, lastError, timeoutMs);
        }

        @Override
        public boolean missingElementSatisfiesCondition() {
            return this.delegate.missingElementSatisfiesCondition();
        }

        @Override
        public boolean test(@Nullable List<WebElement> input) {
            return this.delegate.test(input);
        }
    }
}

