/*
 * Decompiled with CFR 0.152.
 */
package com.clarifai.api.auth;

import com.clarifai.api.auth.Credential;
import com.clarifai.api.auth.CredentialCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryCredentialCache
implements CredentialCache {
    private static final InMemoryCredentialCache INSTANCE = new InMemoryCredentialCache();
    private final Map<String, Credential> cache = new ConcurrentHashMap<String, Credential>();

    public static InMemoryCredentialCache getInstance() {
        return INSTANCE;
    }

    public void putCredential(String appId, Credential credential) {
        this.cache.put(appId, credential);
    }

    public Credential getCredential(String appId) {
        return this.cache.get(appId);
    }

    public void removeCredential(String appId) {
        this.cache.remove(appId);
    }

    private InMemoryCredentialCache() {
    }
}

