/*
 * Decompiled with CFR 0.152.
 */
package com.clarifai.api;

import com.clarifai.api.BaseResponse;
import com.clarifai.api.RecognitionResult;
import com.clarifai.api.exception.ClarifaiBadRequestException;
import com.clarifai.api.exception.ClarifaiException;
import com.clarifai.api.exception.ClarifaiNotAuthorizedException;
import com.clarifai.api.exception.ClarifaiThrottledException;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResponseUtil {
    static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).excludeFieldsWithModifiers(new int[]{8, 128}).registerTypeAdapter(RecognitionResult.class, (Object)new RecognitionResult.Deserializer()).create();

    ResponseUtil() {
    }

    static void throwExceptionForErrorResponse(HttpURLConnection conn, BaseResponse response) throws IOException, ClarifaiException {
        int code;
        String errorMessage = "";
        if (response.statusCode != null) {
            errorMessage = errorMessage + response.statusCode;
        }
        if (response.statusMsg != null) {
            errorMessage = errorMessage + " " + response.statusMsg;
        }
        if (response.results != null && response.results.isJsonPrimitive()) {
            errorMessage = errorMessage + " " + response.results.getAsString();
        }
        if (errorMessage.length() == 0) {
            errorMessage = conn.getResponseMessage();
        }
        if ((code = conn.getResponseCode()) == 401) {
            throw new ClarifaiNotAuthorizedException(errorMessage);
        }
        if (code == 429) {
            int waitSeconds = conn.getHeaderFieldInt("X-Throttle-Wait-Seconds", 10);
            throw new ClarifaiThrottledException(errorMessage, waitSeconds);
        }
        if (code >= 400 && code < 500) {
            throw new ClarifaiBadRequestException(errorMessage);
        }
        if (code >= 500 && code < 600) {
            throw new ClarifaiException(errorMessage);
        }
        throw new ClarifaiException("Unexpected HTTP status code (" + code + "): " + errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T parseJsonAndClose(InputStream in, Class<T> cls) throws JsonParseException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        Object object = GSON.fromJson((Reader)reader, cls);
        return (T)object;
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }
}

