/*
 * Decompiled with CFR 0.152.
 */
package com.clarifai.api;

import com.clarifai.api.ClarifaiRequest;
import com.clarifai.api.Multipart;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecognitionRequest
extends ClarifaiRequest {
    private final List<Item> items = new ArrayList<Item>();
    private String model = "default";
    private Locale locale = null;
    private final Set<String> operations = RecognitionRequest.defaultOperations();
    private final Multipart multipart = new Multipart();

    private static Set<String> defaultOperations() {
        HashSet<String> operations = new HashSet<String>();
        operations.add("tag");
        return operations;
    }

    public RecognitionRequest(File ... files) {
        for (File file : files) {
            this.items.add(new Item(file));
        }
    }

    public RecognitionRequest(byte[] ... imageByteArrays) {
        for (byte[] imageBytes : imageByteArrays) {
            this.items.add(new Item(imageBytes));
        }
    }

    public RecognitionRequest(String ... urls) {
        for (String url : urls) {
            this.items.add(new Item(url));
        }
    }

    public String getModel() {
        return this.model;
    }

    public RecognitionRequest setModel(String model) {
        this.model = model;
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public RecognitionRequest setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public boolean getIncludeTags() {
        return this.operations.contains("tag");
    }

    public RecognitionRequest setIncludeTags(boolean includeTags) {
        if (includeTags) {
            this.operations.add("tag");
        } else {
            this.operations.remove("tag");
        }
        return this;
    }

    public boolean getIncludeEmbedding() {
        return this.operations.contains("embed");
    }

    public RecognitionRequest setIncludeEmbedding(boolean includeEmbedding) {
        if (includeEmbedding) {
            this.operations.add("embed");
        } else {
            this.operations.remove("embed");
        }
        return this;
    }

    public RecognitionRequest addCustomOperation(String customOperation) {
        this.operations.add(customOperation);
        return this;
    }

    @Override
    String getContentType() {
        return "multipart/form-data; boundary=" + this.multipart.getBoundary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writeContent(OutputStream out) throws IOException {
        StringBuilder opParam = new StringBuilder();
        for (String op : this.operations) {
            if (opParam.length() > 0) {
                opParam.append(',');
            }
            opParam.append(op);
        }
        this.multipart.start(out);
        this.multipart.writeParameter("op", opParam.toString());
        this.multipart.writeParameter("model", this.model);
        if (this.locale != null) {
            String language = this.locale.equals(Locale.TRADITIONAL_CHINESE) ? "zh-TW" : this.locale.getLanguage();
            this.multipart.writeParameter("language", language);
        }
        for (Item item : this.items) {
            if (item.url != null) {
                this.multipart.writeParameter("url", item.url);
                continue;
            }
            InputStream in = item.getStream();
            try {
                this.multipart.writeMedia("encoded_data", "media", in);
            }
            finally {
                in.close();
            }
        }
        this.multipart.finish();
    }

    private static class Item {
        File file;
        byte[] imageBytes;
        String url;

        Item(File file) {
            this.file = file;
        }

        Item(byte[] imageBytes) {
            this.imageBytes = imageBytes;
        }

        Item(String url) {
            this.url = url;
        }

        InputStream getStream() throws IOException {
            if (this.file != null) {
                return new FileInputStream(this.file);
            }
            if (this.imageBytes != null) {
                return new ByteArrayInputStream(this.imageBytes);
            }
            return null;
        }
    }
}

