/*
 * Decompiled with CFR 0.152.
 */
package com.clarifai.api;

import com.clarifai.api.BaseResponse;
import com.clarifai.api.ConnectionFactory;
import com.clarifai.api.FormEncoded;
import com.clarifai.api.ResponseUtil;
import com.clarifai.api.auth.Credential;
import com.clarifai.api.auth.CredentialCache;
import com.clarifai.api.exception.ClarifaiException;
import com.clarifai.api.exception.ClarifaiNotAuthorizedException;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.net.HttpURLConnection;

class CredentialManager {
    private static final long MIN_TTL_MS = 60000L;
    private final ConnectionFactory connectionFactory;
    private final String appId;
    private final String appSecret;
    private CredentialCache credentialCache;

    CredentialManager(ConnectionFactory connectionFactory, String appId, String appSecret, CredentialCache credentialCache) {
        this.connectionFactory = connectionFactory;
        this.appId = appId;
        this.appSecret = appSecret;
        this.credentialCache = credentialCache;
    }

    void setCredentialCache(CredentialCache credentialCache) {
        this.credentialCache = credentialCache;
    }

    Credential getCredential() throws ClarifaiException {
        Credential credential = this.credentialCache.getCredential(this.appId);
        if (credential != null && System.currentTimeMillis() < credential.getExpirationTimeMillis() - 60000L) {
            return credential;
        }
        try {
            HttpURLConnection conn = this.connectionFactory.newPost("/token", null);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.getOutputStream().write(new FormEncoded().addParameter("grant_type", "client_credentials").addParameter("client_id", this.appId).addParameter("client_secret", this.appSecret).toByteArray());
            if (conn.getResponseCode() < 200 || conn.getResponseCode() >= 300) {
                BaseResponse response = ResponseUtil.parseJsonAndClose(conn.getErrorStream(), BaseResponse.class);
                ResponseUtil.throwExceptionForErrorResponse(conn, response);
            }
            TokenResponse res = ResponseUtil.parseJsonAndClose(conn.getInputStream(), TokenResponse.class);
            if (res.accessToken != null && res.expiresIn != null) {
                long expiration = System.currentTimeMillis() + res.expiresIn;
                credential = new Credential(res.accessToken, null, expiration);
                this.credentialCache.putCredential(this.appId, credential);
                return credential;
            }
            throw new ClarifaiNotAuthorizedException("Response did not contain access token or expiration.");
        }
        catch (IOException e) {
            throw new ClarifaiException("IOException", e);
        }
        catch (JsonParseException e) {
            throw new ClarifaiException("JSON parser error", e);
        }
    }

    void invalidateCredential() {
        this.credentialCache.removeCredential(this.appId);
    }

    private static class TokenResponse {
        String accessToken;
        Long expiresIn;

        private TokenResponse() {
        }
    }
}

