/*
 * Decompiled with CFR 0.152.
 */
package com.clarifai.api;

import com.clarifai.api.ClarifaiRequester;
import com.clarifai.api.ConnectionFactory;
import com.clarifai.api.CredentialManager;
import com.clarifai.api.FeedbackRequest;
import com.clarifai.api.InfoResult;
import com.clarifai.api.RecognitionRequest;
import com.clarifai.api.RecognitionResult;
import com.clarifai.api.auth.CredentialCache;
import com.clarifai.api.auth.InMemoryCredentialCache;
import com.clarifai.api.exception.ClarifaiException;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClarifaiClient {
    private static final String CLARIFAI_API_ROOT = "https://api.clarifai.com/v1";
    private ConnectionFactory connectionFactory;
    private CredentialManager credentialManager;
    private int maxAttempts = 3;

    public ClarifaiClient() throws ClarifaiException {
        this(ClarifaiClient.getEnvironmentVariable("CLARIFAI_APP_ID"), ClarifaiClient.getEnvironmentVariable("CLARIFAI_APP_SECRET"));
    }

    public ClarifaiClient(String appId, String appSecret) {
        this(CLARIFAI_API_ROOT, appId, appSecret, InMemoryCredentialCache.getInstance());
    }

    ClarifaiClient(String apiRoot, String appId, String appSecret, CredentialCache cache) {
        this.connectionFactory = new ConnectionFactory(apiRoot);
        this.credentialManager = new CredentialManager(this.connectionFactory, appId, appSecret, cache);
    }

    public InfoResult getInfo() throws ClarifaiException {
        return new ClarifaiRequester<InfoResult>(this.connectionFactory, this.credentialManager, ClarifaiRequester.Method.GET, "/info", InfoResult.class, this.maxAttempts).execute(null);
    }

    public List<RecognitionResult> recognize(RecognitionRequest request) throws ClarifaiException {
        return Arrays.asList((Object[])new ClarifaiRequester<RecognitionResult[]>(this.connectionFactory, this.credentialManager, ClarifaiRequester.Method.POST, "/multiop", RecognitionResult[].class, this.maxAttempts).execute(request));
    }

    public void sendFeedback(FeedbackRequest request) throws ClarifaiException {
        new ClarifaiRequester<Void>(this.connectionFactory, this.credentialManager, ClarifaiRequester.Method.POST, "/feedback", Void.class, this.maxAttempts).execute(request);
    }

    public void setCredentialCache(CredentialCache credentialCache) {
        this.credentialManager.setCredentialCache(credentialCache);
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setConnectTimeout(int connectTimeoutMillis) {
        this.connectionFactory.setConnectTimeout(connectTimeoutMillis);
    }

    public int getConnectTimeout() {
        return this.connectionFactory.getConnectTimeout();
    }

    public void setReadTimeout(int readTimeoutMillis) {
        this.connectionFactory.setReadTimeout(readTimeoutMillis);
    }

    public int getReadTimeout() {
        return this.connectionFactory.getReadTimeout();
    }

    private static String getEnvironmentVariable(String name) throws ClarifaiException {
        String value = System.getenv(name);
        if (value == null || value.length() == 0) {
            throw new ClarifaiException("Environment variable '" + name + "' must be defined");
        }
        return value;
    }
}

