/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.exceptions;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Messages {
    @Nonnull
    private final String bundleName;

    public Messages(@Nonnull String bundleName) {
        this.bundleName = bundleName;
    }

    @Nonnull
    public String getBundleName() {
        return this.bundleName;
    }

    @Nonnull
    public String getString(@Nonnull String key, @Nonnull Locale locale, Object ... messageArguments) {
        ResourceBundle bundle = ResourceBundle.getBundle(this.getBundleName(), locale);
        if (messageArguments == null || messageArguments.length == 0) {
            return bundle.getString(key);
        }
        return MessageFormat.format(bundle.getString(key), messageArguments);
    }

    @Nonnull
    public String get(@Nonnull Enum<?> enumValue, @Nonnull Locale locale, Object ... messageArguments) {
        return this.get(enumValue, null, locale, messageArguments);
    }

    public String get(@Nonnull Enum<?> enumValue, @Nullable String category, @Nonnull Locale locale, Object ... messageArguments) {
        String baseKey = enumValue.name();
        String key = category == null ? baseKey : baseKey + "." + category;
        return this.getString(key, locale, messageArguments);
    }
}

