/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.exceptions;

import javax.annotation.Nonnull;

public class ErrorCode {
    private static final char SEPARATOR = '-';
    @Nonnull
    private final Prefix prefix;
    private final int id;

    public ErrorCode(@Nonnull Prefix prefix, int id) {
        this.prefix = prefix;
        this.id = id;
    }

    @Nonnull
    public Prefix getPrefix() {
        return this.prefix;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String format() {
        return this.prefix.asString() + '-' + this.id;
    }

    public String toString() {
        return this.format();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ErrorCode)) {
            return false;
        }
        ErrorCode errorCode = (ErrorCode)o;
        if (this.id != errorCode.id) {
            return false;
        }
        return !(this.prefix != null ? !this.prefix.equals(errorCode.prefix) : errorCode.prefix != null);
    }

    public int hashCode() {
        int result = this.prefix != null ? this.prefix.hashCode() : 0;
        result = 31 * result + this.id;
        return result;
    }

    public static class Prefix {
        @Nonnull
        private final String prefix;

        public Prefix(@Nonnull String prefix) {
            this.prefix = prefix;
        }

        @Nonnull
        public String asString() {
            return this.prefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Prefix)) {
                return false;
            }
            Prefix prefix1 = (Prefix)o;
            return !(this.prefix != null ? !this.prefix.equals(prefix1.prefix) : prefix1.prefix != null);
        }

        public int hashCode() {
            return this.prefix != null ? this.prefix.hashCode() : 0;
        }

        public String toString() {
            return this.prefix;
        }
    }
}

