/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.exceptions;

import com.cedarsoft.exceptions.ErrorCode;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ApplicationException
extends RuntimeException {
    @Nonnull
    private final Details details;
    @Nonnull
    private final Object[] messageArguments;

    protected <T extends Enum<?>> ApplicationException(@Nonnull T details, Object ... messageArguments) {
        this((Throwable)null, details, messageArguments);
    }

    protected <T extends Enum<?>> ApplicationException(@Nullable Throwable cause, @Nonnull T details, Object ... messageArguments) {
        super(cause);
        this.details = (Details)((Object)details);
        this.messageArguments = (Object[])messageArguments.clone();
    }

    @Nonnull
    public Details getDetails() {
        return this.details;
    }

    @Nonnull
    public Object[] getMessageArguments() {
        return (Object[])this.messageArguments.clone();
    }

    @Override
    public String getMessage() {
        return this.details.getErrorCode().toString();
    }

    @Nonnull
    public ErrorCode getErrorCode() {
        return this.details.getErrorCode();
    }

    @Override
    @Nonnull
    public String getLocalizedMessage() {
        return this.details.getLocalizedMessage(this.messageArguments);
    }

    @Nonnull
    public String getLocalizedMessage(@Nonnull Locale locale) {
        return this.details.getLocalizedMessage(locale, this.messageArguments);
    }

    @Nonnull
    public String getTitle() {
        return this.details.getTitle(this.messageArguments);
    }

    @Nonnull
    public String getTitle(@Nonnull Locale locale) {
        return this.details.getTitle(locale, this.messageArguments);
    }

    public static interface Details {
        @Nonnull
        public String getLocalizedMessage(Object ... var1);

        @Nonnull
        public String getLocalizedMessage(@Nonnull Locale var1, Object ... var2);

        @Nonnull
        public String getTitle(Object ... var1);

        @Nonnull
        public String getTitle(@Nonnull Locale var1, Object ... var2);

        @Nonnull
        public ErrorCode getErrorCode();
    }
}

