/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.cluster.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class NonTransientPropertyChangeSupport {
    @Nonnull
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    @Nonnull
    private final Object sourceBean;
    @Nonnull
    private final Map<String, NonTransientPropertyChangeSupport> children = new HashMap<String, NonTransientPropertyChangeSupport>();

    public NonTransientPropertyChangeSupport(@Nonnull Object sourceBean) {
        this.sourceBean = sourceBean;
    }

    public void removePropertyChangeListener(@Nonnull PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void removePropertyChangeListener(@Nonnull String propertyName, @Nonnull PropertyChangeListener listener) {
        this.getChild(propertyName).removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(@Nonnull PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void addPropertyChangeListener(@Nonnull String propertyName, @Nonnull PropertyChangeListener listener) {
        this.getChild(propertyName).addPropertyChangeListener(listener);
    }

    public void firePropertyChange(@Nonnull PropertyChangeEvent evt) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(evt);
        }
        NonTransientPropertyChangeSupport child = this.children.get(evt.getPropertyName());
        if (child != null) {
            child.firePropertyChange(evt);
        }
    }

    @Nonnull
    private NonTransientPropertyChangeSupport getChild(@Nonnull String propertyName) {
        NonTransientPropertyChangeSupport child = this.children.get(propertyName);
        if (child == null) {
            child = new NonTransientPropertyChangeSupport(this.sourceBean);
            this.children.put(propertyName, child);
        }
        return child;
    }

    @Nonnull
    public List<? extends PropertyChangeListener> getPropertyChangeListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

