/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.cluster.event;

import com.cedarsoft.cluster.event.NonTransientPropertyChangeSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClusteredPropertyChangeSupport {
    @Nonnull
    private final Object sourceBean;
    @Nonnull
    private final PropertyChangeSupport transientSupport;
    @Nonnull
    private final NonTransientPropertyChangeSupport nonTransientSupport;

    public ClusteredPropertyChangeSupport(@Nonnull Object sourceBean) {
        this.sourceBean = sourceBean;
        this.transientSupport = new PropertyChangeSupport(sourceBean);
        this.nonTransientSupport = new NonTransientPropertyChangeSupport(sourceBean);
    }

    public void removePropertyChangeListener(@Nonnull PropertyChangeListener listener) {
        this.transientSupport.removePropertyChangeListener(listener);
        this.nonTransientSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@Nonnull String propertyName, @Nonnull PropertyChangeListener listener) {
        this.transientSupport.removePropertyChangeListener(propertyName, listener);
        this.nonTransientSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(@Nonnull PropertyChangeListener listener) {
        this.addPropertyChangeListener(listener, true);
    }

    public void addPropertyChangeListener(@Nonnull PropertyChangeListener listener, boolean isTransient) {
        if (isTransient) {
            this.transientSupport.addPropertyChangeListener(listener);
        } else {
            this.nonTransientSupport.addPropertyChangeListener(listener);
        }
    }

    public void addPropertyChangeListener(@Nonnull String propertyName, @Nonnull PropertyChangeListener listener) {
        this.addPropertyChangeListener(propertyName, listener, true);
    }

    public void addPropertyChangeListener(@Nonnull String propertyName, @Nonnull PropertyChangeListener listener, boolean isTransient) {
        if (isTransient) {
            this.transientSupport.addPropertyChangeListener(propertyName, listener);
        } else {
            this.nonTransientSupport.addPropertyChangeListener(propertyName, listener);
        }
    }

    public void firePropertyChange(@Nonnull String propertyName, @Nullable Object oldValue, @Nullable Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.firePropertyChange(this.createEvent(propertyName, oldValue, newValue));
    }

    public void firePropertyChange(@Nonnull PropertyChangeEvent evt) {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.transientSupport.firePropertyChange(evt);
        this.nonTransientSupport.firePropertyChange(evt);
    }

    @Nonnull
    protected PropertyChangeEvent createEvent(@Nonnull String propertyName, @Nullable Object oldValue, @Nullable Object newValue) {
        return new PropertyChangeEvent(this.sourceBean, propertyName, oldValue, newValue);
    }

    @Nonnull
    public Object getSourceBean() {
        return this.sourceBean;
    }

    @Nonnull
    PropertyChangeSupport getTransientSupport() {
        return this.transientSupport;
    }

    @Nonnull
    public List<? extends PropertyChangeListener> getNonTransientListeners() {
        return Collections.unmodifiableList(this.nonTransientSupport.getPropertyChangeListeners());
    }

    @Nonnull
    public List<? extends PropertyChangeListener> getTransientListeners() {
        return Collections.unmodifiableList(Arrays.asList(this.getTransientSupport().getPropertyChangeListeners()));
    }
}

