/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.cluster;

import com.cedarsoft.objectaccess.ChangeListener;
import com.cedarsoft.objectaccess.ChangedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TransientChangeListenerSupport<T> {
    @Nonnull
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    @Nonnull
    protected final T observedObject;
    private transient List<ChangeListener<T>> transientListeners;

    public TransientChangeListenerSupport(@Nonnull T observedObject) {
        this.observedObject = observedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected List<ChangeListener<T>> getTransientListeners() {
        this.lock.readLock().lock();
        try {
            if (this.transientListeners != null) {
                List<ChangeListener<T>> list = this.transientListeners;
                return list;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.transientListeners == null) {
                this.transientListeners = new ArrayList<ChangeListener<T>>();
            }
            List<ChangeListener<T>> list = this.transientListeners;
            return list;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(@Nonnull ChangeListener<T> listener) {
        this.lock.writeLock().lock();
        try {
            this.getTransientListeners().add(listener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(@Nonnull ChangeListener<T> listener) {
        this.lock.writeLock().lock();
        try {
            this.getTransientListeners().remove(listener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(@Nullable Object context, String ... propertiesPath) {
        ChangedEvent event = new ChangedEvent(this.observedObject, context, propertiesPath);
        this.lock.writeLock().lock();
        try {
            List<ChangeListener<T>> listeners = this.getTransientListeners();
            for (ChangeListener<T> listener : listeners) {
                listener.entryChanged(event);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

