/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.cluster;

import com.cedarsoft.cluster.TransientChangeListenerSupport;
import com.cedarsoft.objectaccess.ChangeListener;
import com.cedarsoft.objectaccess.ChangeListenerSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClusteredChangeListenerSupport<T> {
    @Nonnull
    private final ChangeListenerSupport<T> transientSupport;
    @Nonnull
    private final TransientChangeListenerSupport<T> nonTransientSupport;
    @Nullable
    private ContextProvider contextProvider;

    public ClusteredChangeListenerSupport(@Nonnull T observerdObject) {
        this(observerdObject, null);
    }

    public ClusteredChangeListenerSupport(@Nonnull T observerdObject, @Nullable ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.transientSupport = new ChangeListenerSupport(observerdObject);
        this.nonTransientSupport = new TransientChangeListenerSupport<T>(observerdObject);
    }

    public void addChangeListener(@Nonnull ChangeListener<T> listener, boolean isTransient) {
        if (isTransient) {
            this.transientSupport.addChangeListener(listener);
        } else {
            this.nonTransientSupport.addChangeListener(listener);
        }
    }

    public void removeChangeListener(@Nonnull ChangeListener<T> listener) {
        this.transientSupport.removeChangeListener(listener);
        this.nonTransientSupport.removeChangeListener(listener);
    }

    public void changed(String ... propertiesPath) {
        ContextProvider provider = this.getContextProvider();
        if (provider != null) {
            this.changed(provider.getContext(), propertiesPath);
        } else {
            this.changed((Object)null, propertiesPath);
        }
    }

    public void changed(@Nullable Object context, String ... propertiesPath) {
        if (propertiesPath.length == 0) {
            throw new IllegalArgumentException("Empty properties path");
        }
        this.transientSupport.changed(context, propertiesPath);
        this.nonTransientSupport.changed(context, propertiesPath);
    }

    @Nullable
    public ContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public void setContextProvider(@Nullable ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Nonnull
    public PropertyChangeListener createPropertyListenerDelegate(String ... propertiesPath) {
        final String[] actual = new String[propertiesPath.length + 1];
        System.arraycopy(propertiesPath, 0, actual, 0, propertiesPath.length);
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                actual[actual.length - 1] = evt.getPropertyName();
                ClusteredChangeListenerSupport.this.changed(evt, actual);
            }
        };
    }

    public static interface ContextProvider {
        @Nullable
        public Object getContext();
    }
}

