/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;

public abstract class ThresholdingOutputStream
extends OutputStream {
    private final int threshold;
    private long written;
    private boolean thresholdExceeded;

    @Override
    public void write(int n) {
        this.checkThreshold(1);
        this.getStream().write(n);
        ++this.written;
    }

    @Override
    public void write(byte[] byArray) {
        this.checkThreshold(byArray.length);
        this.getStream().write(byArray);
        this.written += (long)byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.checkThreshold(n2);
        this.getStream().write(byArray, n, n2);
        this.written += (long)n2;
    }

    @Override
    public void flush() {
        this.getStream().flush();
    }

    @Override
    public void close() {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getStream().close();
    }

    protected void checkThreshold(int n) {
        if (!this.thresholdExceeded && this.written + (long)n > (long)this.threshold) {
            this.thresholdExceeded = true;
            this.thresholdReached();
        }
    }

    protected abstract OutputStream getStream();

    protected abstract void thresholdReached();
}

