/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.Cache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.LruCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal.$Gson$Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal.Pair;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public final class FieldAttributes {
    private static final Cache ANNOTATION_CACHE = new LruCache(FieldAttributes.getMaxCacheSize());
    private final Class declaringClazz;
    private final Field field;
    private final Class declaredType;
    private final boolean isSynthetic;
    private final int modifiers;
    private final String name;
    private Type genericType;
    private Collection annotations;

    FieldAttributes(Class clazz, Field field) {
        this.declaringClazz = (Class)$Gson$Preconditions.checkNotNull(clazz);
        this.name = field.getName();
        this.declaredType = field.getType();
        this.isSynthetic = field.isSynthetic();
        this.modifiers = field.getModifiers();
        this.field = field;
    }

    private static int getMaxCacheSize() {
        int n = 2000;
        try {
            String string = System.getProperty("com.google.gson.annotation_cache_size_hint", String.valueOf(2000));
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 2000;
        }
    }

    public String getName() {
        return this.name;
    }

    public Type getDeclaredType() {
        if (this.genericType == null) {
            this.genericType = this.field.getGenericType();
        }
        return this.genericType;
    }

    public Class getDeclaredClass() {
        return this.declaredType;
    }

    public Annotation getAnnotation(Class clazz) {
        return FieldAttributes.getAnnotationFromArray(this.getAnnotations(), clazz);
    }

    public Collection getAnnotations() {
        if (this.annotations == null) {
            Pair pair = new Pair(this.declaringClazz, this.name);
            Collection<Annotation> collection = (Collection<Annotation>)ANNOTATION_CACHE.getElement(pair);
            if (collection == null) {
                collection = Collections.unmodifiableCollection(Arrays.asList(this.field.getAnnotations()));
                ANNOTATION_CACHE.addElement(pair, collection);
            }
            this.annotations = collection;
        }
        return this.annotations;
    }

    public boolean hasModifier(int n) {
        return (this.modifiers & n) != 0;
    }

    boolean isSynthetic() {
        return this.isSynthetic;
    }

    private static Annotation getAnnotationFromArray(Collection collection, Class clazz) {
        for (Annotation annotation : collection) {
            if (annotation.annotationType() != clazz) continue;
            return annotation;
        }
        return null;
    }
}

