/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Throwables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LoadingCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashMultimap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multimap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.AllowConcurrentEvents;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.AnnotatedSubscriberFinder$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.AnnotatedSubscriberFinder$MethodIdentifier;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventSubscriber;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Subscribe;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.SubscriberFindingStrategy;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.SynchronizedEventSubscriber;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeToken;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;

class AnnotatedSubscriberFinder
implements SubscriberFindingStrategy {
    private static final LoadingCache subscriberMethodsCache = CacheBuilder.newBuilder().weakKeys().build(new AnnotatedSubscriberFinder$1());

    AnnotatedSubscriberFinder() {
    }

    @Override
    public Multimap findAllSubscribers(Object object) {
        HashMultimap hashMultimap = HashMultimap.create();
        Class<?> clazz = object.getClass();
        for (Method method : AnnotatedSubscriberFinder.getAnnotatedMethods(clazz)) {
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz2 = classArray[0];
            EventSubscriber eventSubscriber = AnnotatedSubscriberFinder.makeSubscriber(object, method);
            hashMultimap.put(clazz2, eventSubscriber);
        }
        return hashMultimap;
    }

    private static ImmutableList getAnnotatedMethods(Class clazz) {
        try {
            return (ImmutableList)subscriberMethodsCache.getUnchecked(clazz);
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            throw Throwables.propagate(uncheckedExecutionException.getCause());
        }
    }

    private static ImmutableList getAnnotatedMethodsInternal(Class clazz) {
        Set set = TypeToken.of(clazz).getTypes().rawTypes();
        HashMap hashMap = Maps.newHashMap();
        for (Class clazz2 : set) {
            for (Method method : clazz2.getMethods()) {
                if (!method.isAnnotationPresent(Subscribe.class)) continue;
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length != 1) {
                    throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation, but requires " + classArray.length + " arguments.  Event subscriber methods must require a single argument.");
                }
                AnnotatedSubscriberFinder$MethodIdentifier annotatedSubscriberFinder$MethodIdentifier = new AnnotatedSubscriberFinder$MethodIdentifier(method);
                if (hashMap.containsKey(annotatedSubscriberFinder$MethodIdentifier)) continue;
                hashMap.put(annotatedSubscriberFinder$MethodIdentifier, method);
            }
        }
        return ImmutableList.copyOf(hashMap.values());
    }

    private static EventSubscriber makeSubscriber(Object object, Method method) {
        EventSubscriber eventSubscriber = AnnotatedSubscriberFinder.methodIsDeclaredThreadSafe(method) ? new EventSubscriber(object, method) : new SynchronizedEventSubscriber(object, method);
        return eventSubscriber;
    }

    private static boolean methodIsDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }

    static /* synthetic */ ImmutableList access$000(Class clazz) {
        return AnnotatedSubscriberFinder.getAnnotatedMethodsInternal(clazz);
    }
}

