/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.tycho.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.ArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.java.api.model.JavaArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProjectDirectoryDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.AbstractScanner;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.osgitools.project.EclipsePluginProject;
import org.eclipse.tycho.core.shared.BuildProperties;

@ScannerPlugin.Requires(value={MavenProjectDirectoryDescriptor.class})
public class TychoProjectScannerPlugin
extends AbstractScannerPlugin<MavenProject, MavenProjectDirectoryDescriptor> {
    private static final String PACKAGING_ECLIPSE_PLUGIN = "eclipse-plugin";

    public boolean accepts(MavenProject item, String path, Scope scope) {
        return PACKAGING_ECLIPSE_PLUGIN.equals(item.getPackaging());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenProjectDirectoryDescriptor scan(MavenProject project, String path, Scope scope, Scanner scanner) throws IOException {
        MavenProjectDirectoryDescriptor mavenProjectDirectoryDescriptor = (MavenProjectDirectoryDescriptor)scanner.getContext().peek(MavenProjectDirectoryDescriptor.class);
        for (ArtifactFileDescriptor artifact : mavenProjectDirectoryDescriptor.getCreatesArtifacts()) {
            if (!(artifact instanceof JavaArtifactFileDescriptor) || !artifact.getType().equals(PACKAGING_ECLIPSE_PLUGIN)) continue;
            scanner.getContext().push(JavaArtifactFileDescriptor.class, (Object)((JavaArtifactFileDescriptor)artifact));
            try {
                for (File file : this.getPdeFiles(project)) {
                    String filePath;
                    FileDescriptor fileDescriptor = (FileDescriptor)scanner.scan((Object)file, filePath = this.getDirectoryPath(project.getBasedir(), file), (Scope)JavaScope.CLASSPATH);
                    if (fileDescriptor == null) continue;
                    artifact.getContains().add(fileDescriptor);
                }
            }
            finally {
                scanner.getContext().pop(JavaArtifactFileDescriptor.class);
            }
        }
        return mavenProjectDirectoryDescriptor;
    }

    private List<File> getPdeFiles(MavenProject project) throws IOException {
        EclipsePluginProject pdeProject;
        Iterator<PlexusIoResource> iterator;
        Object value = project.getContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_PROJECT);
        ArrayList<File> pdeFiles = new ArrayList<File>();
        if (value instanceof EclipsePluginProject && (iterator = this.getPDEBinaries(project, pdeProject = (EclipsePluginProject)value)).hasNext()) {
            do {
                PlexusIoResource resource;
                File file;
                if (!(file = new File((resource = iterator.next()).getURL().getFile())).exists() || file.isDirectory()) continue;
                pdeFiles.add(file);
            } while (iterator.hasNext());
        }
        return pdeFiles;
    }

    private Iterator<PlexusIoResource> getPDEBinaries(MavenProject project, EclipsePluginProject pdeProject) throws IOException {
        BuildProperties buildProperties = pdeProject.getBuildProperties();
        return this.getResourceFileCollection(project.getBasedir(), buildProperties.getBinIncludes(), buildProperties.getBinExcludes()).getResources();
    }

    protected PlexusIoFileResourceCollection getResourceFileCollection(File basedir, List<String> includes, List<String> excludes) {
        PlexusIoFileResourceCollection collection = new PlexusIoFileResourceCollection();
        collection.setBaseDir(basedir);
        if (includes.isEmpty()) {
            collection.setIncludes(new String[]{""});
        } else {
            collection.setIncludes(includes.toArray(new String[includes.size()]));
        }
        LinkedHashSet<String> allExcludes = new LinkedHashSet<String>();
        if (excludes != null) {
            allExcludes.addAll(excludes);
        }
        allExcludes.addAll(Arrays.asList(AbstractScanner.DEFAULTEXCLUDES));
        collection.setExcludes(allExcludes.toArray(new String[allExcludes.size()]));
        return collection;
    }
}

