/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphml.report.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

class GraphMLNamespaceContext
implements NamespaceContext {
    private static final String XSI_NS_PREFIX = "xsi";
    private Map<String, String> namespaceByPrefix = this.createDefaultNamespaces();
    private Map<String, String> prefixByNameSpace;
    private Map<String, String> schemaLocations;

    public GraphMLNamespaceContext(Map<String, String> additionalNamespaces, Map<String, String> schemaLocations) {
        this.namespaceByPrefix.putAll(additionalNamespaces);
        this.schemaLocations = schemaLocations;
        this.prefixByNameSpace = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.namespaceByPrefix.entrySet()) {
            this.prefixByNameSpace.put(entry.getValue(), entry.getKey());
        }
    }

    private Map<String, String> createDefaultNamespaces() {
        LinkedHashMap<String, String> defaultNS = new LinkedHashMap<String, String>();
        defaultNS.put(XSI_NS_PREFIX, "http://www.w3.org/2001/XMLSchema-instance");
        return defaultNS;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.getOrDefault(this.namespaceByPrefix, prefix, "");
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.getOrDefault(this.prefixByNameSpace, namespaceURI, "");
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return Collections.singletonList(this.getPrefix(namespaceURI)).iterator();
    }

    Map<String, String> getNamespaces() {
        return this.namespaceByPrefix;
    }

    public Map<String, String> getSchemaLocations() {
        return this.schemaLocations;
    }

    private <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return defaultValue;
    }
}

