/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState64BitsInteger;
import io.github.bucket4j.BucketStateIEEE754;
import io.github.bucket4j.MathType;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.versioning.Version;
import java.io.IOException;
import java.util.Map;

public interface BucketState {
    public BucketState copy();

    public BucketConfiguration getConfiguration();

    public void setConfiguration(BucketConfiguration var1);

    public BucketState replaceConfiguration(BucketConfiguration var1, TokensInheritanceStrategy var2, long var3);

    public void copyStateFrom(BucketState var1);

    public long getAvailableTokens();

    public void consume(long var1);

    public long calculateDelayNanosAfterWillBePossibleToConsume(long var1, long var3, boolean var5);

    public long calculateFullRefillingTime(long var1);

    public void refillAllBandwidth(long var1);

    public void addTokens(long var1);

    public void reset();

    public void forceAddTokens(long var1);

    public long getCurrentSize(int var1);

    public long getRoundingError(int var1);

    public MathType getMathType();

    public static BucketState createInitialState(BucketConfiguration configuration, MathType mathType, long currentTimeNanos) {
        switch (mathType) {
            case INTEGER_64_BITS: {
                return new BucketState64BitsInteger(configuration, currentTimeNanos);
            }
            case IEEE_754: {
                return new BucketStateIEEE754(configuration, currentTimeNanos);
            }
        }
        throw new IllegalStateException("Unsupported mathType:" + mathType);
    }

    public static <S> BucketState deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
        int typeId = adapter.readInt(input);
        if (typeId == BucketState64BitsInteger.SERIALIZATION_HANDLE.getTypeId()) {
            return BucketState64BitsInteger.SERIALIZATION_HANDLE.deserialize(adapter, input, backwardCompatibilityVersion);
        }
        if (typeId == BucketStateIEEE754.SERIALIZATION_HANDLE.getTypeId()) {
            return BucketStateIEEE754.SERIALIZATION_HANDLE.deserialize(adapter, input, backwardCompatibilityVersion);
        }
        throw new IOException("Unknown typeId=" + typeId);
    }

    public static <O> void serialize(SerializationAdapter<O> adapter, O output, BucketState state, Version backwardCompatibilityVersion) throws IOException {
        switch (state.getMathType()) {
            case INTEGER_64_BITS: {
                adapter.writeInt(output, BucketState64BitsInteger.SERIALIZATION_HANDLE.getTypeId());
                BucketState64BitsInteger.SERIALIZATION_HANDLE.serialize(adapter, output, (BucketState64BitsInteger)state, backwardCompatibilityVersion);
                break;
            }
            case IEEE_754: {
                adapter.writeInt(output, BucketStateIEEE754.SERIALIZATION_HANDLE.getTypeId());
                BucketStateIEEE754.SERIALIZATION_HANDLE.serialize(adapter, output, (BucketStateIEEE754)state, backwardCompatibilityVersion);
                break;
            }
            default: {
                throw new IOException("Unknown mathType=" + state.getMathType());
            }
        }
    }

    public static BucketState fromJsonCompatibleSnapshot(Map<String, Object> snapshot, Version backwardCompatibilityVersion) throws IOException {
        String type = (String)snapshot.get("type");
        if (BucketState64BitsInteger.SERIALIZATION_HANDLE.getTypeName().equals(type)) {
            return BucketState64BitsInteger.SERIALIZATION_HANDLE.fromJsonCompatibleSnapshot(snapshot, backwardCompatibilityVersion);
        }
        if (BucketStateIEEE754.SERIALIZATION_HANDLE.getTypeName().equals(type)) {
            return BucketStateIEEE754.SERIALIZATION_HANDLE.fromJsonCompatibleSnapshot(snapshot, backwardCompatibilityVersion);
        }
        throw new IOException("Unknown typeName=" + type);
    }

    public static Object toJsonCompatibleSnapshot(BucketState state, Version backwardCompatibilityVersion) throws IOException {
        switch (state.getMathType()) {
            case INTEGER_64_BITS: {
                Map<String, Object> result = BucketState64BitsInteger.SERIALIZATION_HANDLE.toJsonCompatibleSnapshot((BucketState64BitsInteger)state, backwardCompatibilityVersion);
                result.put("type", BucketState64BitsInteger.SERIALIZATION_HANDLE.getTypeName());
                return result;
            }
            case IEEE_754: {
                Map<String, Object> result = BucketStateIEEE754.SERIALIZATION_HANDLE.toJsonCompatibleSnapshot((BucketStateIEEE754)state, backwardCompatibilityVersion);
                result.put("type", BucketStateIEEE754.SERIALIZATION_HANDLE.getTypeName());
                return result;
            }
        }
        throw new IOException("Unknown mathType=" + state.getMathType());
    }
}

