/*******************************************************************************
 * Copyright 2017 Bstek
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License.  You may obtain a copy
 * of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 ******************************************************************************/
package com.bstek.uflo.process.node;

import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.process.handler.ActionHandler;

/**
 * @author Jacky.gao
 * @since 2013年8月12日
 */
public class ActionNode extends Node {
	private static final long serialVersionUID = -3522477911199203025L;
	private String handlerBean;
	@Override
	public boolean enter(Context context, ProcessInstance processInstance) {
		return true;
	}
	
	@Override
	public String leave(Context context, ProcessInstance processInstance,String flowName) {
		ActionHandler handler=(ActionHandler)context.getApplicationContext().getBean(handlerBean);
		handler.handle(processInstance, context);
		return leaveNode(context, processInstance, flowName);
	}

	@Override
	public void cancel(Context context, ProcessInstance processInstance) {
	}
	
	@Override
	public NodeType getType() {
		return NodeType.Action;
	}

	public String getHandlerBean() {
		return handlerBean;
	}

	public void setHandlerBean(String handlerBean) {
		this.handlerBean = handlerBean;
	}
}
