/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.rest.validation.mapper;

import com.browserup.bup.rest.validation.mapper.model.ConstraintsErrors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.commons.lang3.StringUtils;

public class ConstraintViolationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    private static final String PARAMETER_NAME_ATTRIBUTE = "paramName";

    public Response toResponse(ConstraintViolationException exception) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.createConstraintErrors(exception)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private ConstraintsErrors createConstraintErrors(ConstraintViolationException exception) {
        ConstraintsErrors errors = new ConstraintsErrors();
        exception.getConstraintViolations().stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v.getMessage())).forEach(violation -> errors.addError(this.getArgumentName((ConstraintViolation<?>)violation), violation.getMessage()));
        return errors;
    }

    private String getArgumentName(ConstraintViolation<?> violation) {
        Object paramName = violation.getConstraintDescriptor().getAttributes().get(PARAMETER_NAME_ATTRIBUTE);
        String argumentIdentifier = paramName instanceof String && paramName.toString().length() > 0 ? (String)paramName : StringUtils.substringAfterLast((String)violation.getPropertyPath().toString(), (String)".");
        return argumentIdentifier;
    }
}

