/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.rest.validation;

import com.browserup.bup.proxy.ProxyManager;
import com.browserup.bup.rest.validation.util.MessageSanitizer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={PortWithExistingProxyConstraintValidator.class})
public @interface PortWithExistingProxyConstraint {
    public String message() default "";

    public String paramName() default "port";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class PortWithExistingProxyConstraintValidator
    implements ConstraintValidator<PortWithExistingProxyConstraint, Integer> {
        private static final Logger LOG = LoggerFactory.getLogger(PortWithExistingProxyConstraintValidator.class);
        private static final String PARAM_NAME = "proxy port";
        private final ProxyManager proxyManager;

        public PortWithExistingProxyConstraintValidator(@Context ProxyManager proxyManager) {
            this.proxyManager = proxyManager;
        }

        public void initialize(PortWithExistingProxyConstraint constraintAnnotation) {
        }

        public boolean isValid(Integer value, ConstraintValidatorContext context) {
            if (this.proxyManager.get(value) != null) {
                return true;
            }
            String escapedValue = MessageSanitizer.escape(value.toString());
            String errorMessage = String.format("No proxy server found for specified port %s", escapedValue);
            LOG.warn(errorMessage);
            context.buildConstraintViolationWithTemplate(errorMessage).addPropertyNode(PARAM_NAME).addConstraintViolation();
            return false;
        }
    }
}

