/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.rest.validation;

import com.browserup.bup.rest.validation.util.MessageSanitizer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Pattern;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={PatternValidator.class})
public @interface PatternConstraint {
    public String message() default "";

    public String paramName() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class PatternValidator
    implements ConstraintValidator<PatternConstraint, String> {
        private static final Logger LOG = LoggerFactory.getLogger(PatternValidator.class);

        public void initialize(PatternConstraint constraintAnnotation) {
        }

        public boolean isValid(String value, ConstraintValidatorContext context) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return true;
            }
            try {
                Pattern.compile(value);
                return true;
            }
            catch (Exception ex) {
                String escapedValue = MessageSanitizer.escape(value);
                String errorMessage = String.format("URL parameter '%s' is not a valid regexp", escapedValue);
                LOG.warn(errorMessage);
                context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
                return false;
            }
        }
    }
}

