/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.rest.validation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={NotNullValidator.class})
public @interface NotNullConstraint {
    public String message() default "";

    public String paramName() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class NotNullValidator
    implements ConstraintValidator<NotNullConstraint, Object> {
        private static final Logger LOG = LoggerFactory.getLogger(NotNullValidator.class);

        public void initialize(NotNullConstraint constraintAnnotation) {
        }

        public boolean isValid(Object value, ConstraintValidatorContext context) {
            if (value != null) {
                return true;
            }
            String errorMessage = "Expected not null value";
            LOG.warn(errorMessage);
            context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            return false;
        }
    }
}

