/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.rest.validation;

import com.browserup.bup.rest.validation.util.MessageSanitizer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={NotBlankValidator.class})
public @interface NotBlankConstraint {
    public String message() default "";

    public String paramName() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class NotBlankValidator
    implements ConstraintValidator<NotBlankConstraint, Object> {
        private static final Logger LOG = LoggerFactory.getLogger(NotBlankValidator.class);

        public void initialize(NotBlankConstraint constraintAnnotation) {
        }

        public boolean isValid(Object value, ConstraintValidatorContext context) {
            if (value != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(value))) {
                return true;
            }
            String escapedValue = MessageSanitizer.escape(value == null ? null : value.toString());
            String errorMessage = String.format("Expected not empty value, got '%s'", escapedValue);
            LOG.warn(errorMessage);
            context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            return false;
        }
    }
}

